package ru.yandex.dispatcher.producer;

import java.io.IOException;
import java.math.BigDecimal;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.dispatcher.common.DelayShardMessage;
import ru.yandex.util.timesource.TimeSource;

public class DelayShardHandler extends QueueRequestHandlerBase {
    public DelayShardHandler(final Producer producer) {
        super(producer);
    }

    @Override
    protected void addMessages(
        final QueueRequest request)
        throws IOException, HttpException
    {
        DelayShardMessage msg = new DelayShardMessage(
            request.cgiParams().getInt("delay"),
            TimeSource.INSTANCE.currentTimeMillis());
        BigDecimal position = producer.getPosition(request.request());
        addMessage(request, request.commonPrefix(), msg, position);
    }
}
