package ru.yandex.dispatcher.producer;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

import org.apache.http.HttpStatus;

import ru.yandex.dispatcher.common.VoidCallback;
import ru.yandex.dispatcher.common.ZooException;
import ru.yandex.dispatcher.common.ZooNoNodeException;
import ru.yandex.dispatcher.common.mappedvars.ZooLock;

import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.BadGatewayException;

public class DropPositionCallback extends VoidCallback {
    private final ProxySession session;
    private final AtomicInteger countdown;
    private final ZooLock lock;

    public DropPositionCallback(
        final ProxySession session,
        final AtomicInteger countdown,
        final ZooLock lock)
    {
        this.session = session;
        this.countdown = countdown;
        this.lock = lock;
    }

    private void checkCompletion() {
        if (countdown.decrementAndGet() == 0) {
            try {
                lock.unlock();
            } catch (ZooException e) {
                session.logger().log(Level.WARNING, "Unlock failed", e);
            }
            session.response(HttpStatus.SC_OK);
        }
    }

    @Override
    public void dataImpl(final Void nothing) {
        checkCompletion();
    }

    @Override
    public void dataChangedImpl() {
        errorImpl(new ZooException("Data changed"));
    }

    @Override
    public void errorImpl(final ZooException e) {
        if (e instanceof ZooNoNodeException) {
            checkCompletion();
        } else if (countdown.getAndSet(0) > 0) {
            try {
                lock.unlock();
            } catch (ZooException ex) {
                e.addSuppressed(ex);
            }
            session.handleException(new BadGatewayException(e));
        }
    }
}

