package ru.yandex.dispatcher.producer;

import java.io.IOException;
import java.math.BigDecimal;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.dispatcher.common.HttpGetMessage;
import ru.yandex.util.timesource.TimeSource;

public class GetDataHandler extends QueueRequestHandlerBase {
    public GetDataHandler(final Producer producer) {
        super(producer);
    }

    @Override
    protected void addMessages(
        final QueueRequest request)
        throws IOException, HttpException
    {
        HttpGetMessage msg = new HttpGetMessage(
            request.request().getRequestLine().getUri(),
            request.doWait(),
            TimeSource.INSTANCE.currentTimeMillis());
        msg.copyHeadersFrom(request.request());
        BigDecimal position = producer.getPosition(request.request());
        addMessage(request, request.commonPrefix(), msg, position);
    }
}
