package ru.yandex.dispatcher.producer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableProducerConfig
    extends ImmutableHttpProxyConfig
    implements ProducerConfig
{
    private final String searchMapPath;
    private final int syncHelperThreads;
    private final int zookeeperTimeout;
    private final int waitTimeout;
    private final int maxGroupSize;
    private final int maxGroupWeight;
    private final int maxGroupDelay;
    private final int maxStatusGroupSize;
    private final int maxStatusGroupWeight;
    private final int maxStatusGroupDelay;
    private final Set<String> services;
    private final Set<String> consumerServices;
    private final ImmutableHttpTargetConfig zooHttpTargetConfig;
    private final int statusProxyFallbackDelay;
    private final List<Integer> staterTimeBoundaries;

    public ImmutableProducerConfig(final ProducerConfig config)
        throws ConfigException
    {
        super(config);
        searchMapPath = config.searchMapPath();
        syncHelperThreads = config.syncHelperThreads();
        zookeeperTimeout = config.zookeeperTimeout();
        waitTimeout = config.waitTimeout();
        maxGroupSize = config.maxGroupSize();
        maxGroupWeight = config.maxGroupWeight();
        maxGroupDelay = config.maxGroupDelay();
        maxStatusGroupSize = config.maxStatusGroupSize();
        maxStatusGroupWeight = config.maxStatusGroupWeight();
        maxStatusGroupDelay = config.maxStatusGroupDelay();
        if (config.services().isEmpty()) {
            services = Collections.emptySet();
        } else {
            services = Collections.unmodifiableSet(
                new HashSet<>(config.services()));
        }
        if (config.consumerServices().isEmpty()) {
            consumerServices = Collections.emptySet();
        } else {
            consumerServices = Collections.unmodifiableSet(
                new HashSet<>(config.consumerServices()));
        }
        zooHttpTargetConfig =
            new ImmutableHttpTargetConfig(config.zooHttpTargetConfig());
        statusProxyFallbackDelay = config.statusProxyFallbackDelay();
        staterTimeBoundaries = new ArrayList<>(config.staterTimeBoundaries());
    }

    @Override
    public int syncHelperThreads() {
        return syncHelperThreads;
    }

    @Override
    public int zookeeperTimeout() {
        return zookeeperTimeout;
    }

    @Override
    public int waitTimeout() {
        return waitTimeout;
    }

    @Override
    public String searchMapPath() {
        return searchMapPath;
    }

    @Override
    public int maxGroupDelay() {
        return maxGroupDelay;
    }

    @Override
    public int maxGroupSize() {
        return maxGroupSize;
    }

    @Override
    public int maxGroupWeight() {
        return maxGroupWeight;
    }

    @Override
    public int maxStatusGroupDelay() {
        return maxStatusGroupDelay;
    }

    @Override
    public int maxStatusGroupSize() {
        return maxStatusGroupSize;
    }

    @Override
    public int maxStatusGroupWeight() {
        return maxStatusGroupWeight;
    }

    @Override
    public Set<String> services() {
        return services;
    }

    @Override
    public Set<String> consumerServices() {
        return consumerServices;
    }

    @Override
    public ImmutableHttpTargetConfig zooHttpTargetConfig() {
        return zooHttpTargetConfig;
    }

    @Override
    public int statusProxyFallbackDelay() {
        return statusProxyFallbackDelay;
    }

    @Override
    public List<Integer> staterTimeBoundaries() {
        return staterTimeBoundaries;
    }
}

