package ru.yandex.dispatcher.producer;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class ProducerConfigBuilder
    extends AbstractProducerConfigBuilder<ProducerConfigBuilder>
{
    public ProducerConfigBuilder() {
        super(ProducerConfigDefaults.INSTANCE);
    }

    public ProducerConfigBuilder(final ProducerConfig config) {
        super(config);
    }

    public ProducerConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, ProducerConfigDefaults.INSTANCE);
    }

    public ProducerConfigBuilder(
        final IniConfig config,
        final ProducerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ProducerConfigBuilder self() {
        return this;
    }

    public ImmutableProducerConfig build() throws ConfigException {
        return new ImmutableProducerConfig(this);
    }
}
