package ru.yandex.dispatcher.producer;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigBuilder;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;
import ru.yandex.parser.config.ConfigException;

public class ProducerConfigDefaults
    extends HttpProxyConfigDefaults
    implements ProducerConfig
{
    public static final ProducerConfigDefaults INSTANCE =
        new ProducerConfigDefaults();

    protected ProducerConfigDefaults() {
    }

    @Override
    public String name() {
        return "Producer";
    }

    @Override
    public int syncHelperThreads() {
        return 100;
    }

    @Override
    public int zookeeperTimeout() {
        return 40000;
    }

    @Override
    public int waitTimeout() {
        return 60000;
    }

    @Override
    public String searchMapPath() {
        return "/var/cache/yamail/searchmap.txt";
    }

    @Override
    public int maxGroupSize() {
        return 50;
    }

    @Override
    public int maxGroupWeight() {
        return 1048576;
    }

    @Override
    public int maxGroupDelay() {
        return 1000;
    }

    @Override
    public int maxStatusGroupSize() {
        return 50;
    }

    @Override
    public int maxStatusGroupWeight() {
        return 1048576;
    }

    @Override
    public int maxStatusGroupDelay() {
        return 1000;
    }

    @Override
    public Set<String> services() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> consumerServices() {
        return Collections.emptySet();
    }

    @Override
    public HttpTargetConfig zooHttpTargetConfig() {
        return new HttpTargetConfigBuilder()
            .connections(10)
            .timeout(30000)
            .connectTimeout(3000);
    }

    @Override
    public int statusProxyFallbackDelay() {
        return 100;
    }

    @Override
    public List<Integer> staterTimeBoundaries() {
        return List.of(10, 25, 50, 75, 100, 150, 200, 300, 600, 1200, 3000);
    }

}

