package ru.yandex.dispatcher.producer;

import java.math.BigDecimal;
import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;
import org.apache.zookeeper.CreateMode;

import ru.yandex.dispatcher.common.ErrorMessage;
import ru.yandex.dispatcher.common.mappedvars.ZooBigDecimalNode;

public class QueueMessage {
    private String path;
    private final String hash;
    private final byte[] data;
    private final QueueRequest request;
    private final long prefix;
    private final CreateMode mode;
    private int version = -1;
    private ErrorMessage response = null;
    private Long queueId = null;
    private ZooBigDecimalNode producerPositionNode = null;
    private BigDecimal producerPosition = null;

    public FutureCallback<QueueMessage> callback;

    public QueueMessage(
        final String path,
        final String hash,
        final byte[] data,
        final long prefix,
        final CreateMode mode,
        final QueueRequest request)
    {
        this.callback = callback;
        this.path = path;
        this.hash = hash;
        this.data = data;
        this.prefix = prefix;
        this.mode = mode;
        this.request = request;
    }

    public int version() {
        return this.version;
    }

    public void version(final int version) {
        this.version = version;
    }

    public void response(final ErrorMessage response) {
        this.response = response;
    }

    public ErrorMessage response() {
        return response;
    }

    public void setCallback(FutureCallback<QueueMessage> callback) {
        this.callback = callback;
    }

    public FutureCallback<QueueMessage> callback() {
        return callback;
    }

    public int weight() {
        return data.length + path.length() << 1;
    }

    public String path() {
        return path;
    }


    public String hash() {
        return hash;
    }

    public byte[] data() {
        return data;
    }

    public CreateMode mode() {
        return mode;
    }

    public long prefix() {
        return prefix;
    }

    public ZooBigDecimalNode producerPositionNode() {
        return producerPositionNode;
    }

    public void setProducerPositionNode(final ZooBigDecimalNode node) {
        producerPositionNode = node;
    }

    public BigDecimal producerPosition() {
        return producerPosition;
    }

    public void setProducerPosition(final BigDecimal position) {
        producerPosition = position;
    }

    public Long queueId() {
        return queueId;
    }

    public void completed(final String retPath) {
        queueId = Long.parseLong(retPath.substring(this.path.length()));
        this.path = retPath;
        if (producerPositionNode != null || producerPosition != null) {
            if (producerPositionNode.cachedValue() == null
                || producerPositionNode.cachedValue().compareTo(
                    producerPosition) < 0)
            {
                producerPositionNode.setCachedValue(producerPosition);
            }
        }
        if (request.logger().isLoggable(Level.INFO)) {
            request.logger().info(
                "Created file: "
                + retPath + ", hash=" + hash);
        }
        callback.completed(this);
    }

    public void failed(Exception e) {
        callback.failed(e);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (queueId == null) {
            sb.append("Unsaved: ");
            sb.append(path);
        } else {
            sb.append("Saved: id=");
            sb.append(queueId);
        }
        if (producerPosition != null) {
            sb.append(", producer position=");
            sb.append(producerPosition);
        }
        return sb.toString();
    }
}
