package ru.yandex.dispatcher.producer;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.apache.http.Header;
import org.apache.http.HttpRequest;

import ru.yandex.dispatcher.common.mappedvars.ZooLongNode;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.HeadersParser;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.util.timesource.TimeSource;

public class QueueRequest {
    private final ProxySession session;
    private final HttpRequest request;
    private final Logger logger;
    private final String service;
    private final String producerName;
    private Long commonPrefix;
    private final boolean doWait;
    private final int timeout;
    private final boolean multiPart;
    private final boolean checkDuplicate;
    private final boolean memoryCheckOnly;
    private final boolean failOnDuplicate;
    private final String hash;
    private ZooLongNode positionNode;
    private final List<QueueMessage> messages;
    private byte[] payload = null;
    private final long requestStartTime;
    private final CgiParams cgiParams;
    private final HeadersParser headers;

    public QueueRequest(final QueueRequest other)
        throws BadRequestException
    {
        this(
            other.session,
            other.request,
            other.logger,
            other.service,
            other.producerName,
            other.commonPrefix,
            other.doWait,
            other.timeout,
            other.multiPart,
            other.cgiParams);
    }

    public QueueRequest(
        final ProxySession session,
        final HttpRequest request,
        final Logger logger,
        final String service,
        final String producerName,
        final Long commonPrefix,
        final boolean doWait,
        final int timeout,
        final boolean multiPart,
        final CgiParams cgiParams)
        throws BadRequestException
    {
        this.session = session;
        this.request = request;
        this.logger = logger;
        this.service = service;
        this.producerName = producerName;
        this.commonPrefix = commonPrefix;
        this.doWait = doWait;
        this.timeout = timeout;
        this.multiPart = multiPart;
        this.positionNode = null;
        this.cgiParams = cgiParams;
        this.messages = new ArrayList<>();
        requestStartTime = TimeSource.INSTANCE.currentTimeMillis();
        this.headers = new HeadersParser(request);
        final boolean checkDup =
            headerOrCgi(YandexHeaders.CHECK_DUPLICATE, false);
        final boolean checkMemDup =
            headerOrCgi(YandexHeaders.CHECK_MEM_DUPLICATE, false);
        final boolean failOnDup =
            headerOrCgi(YandexHeaders.FAIL_ON_DUPLICATE, false);
        final boolean failOnMemDup =
            headerOrCgi(YandexHeaders.FAIL_ON_MEM_DUPLICATE, false);
        if (checkDup || checkMemDup || failOnDup || failOnMemDup) {
            this.checkDuplicate = true;
        } else {
            this.checkDuplicate = false;
        }
        if (checkMemDup || failOnMemDup) {
            this.memoryCheckOnly = true;
        } else {
            this.memoryCheckOnly = false;
        }
        if (failOnDup || failOnMemDup) {
            this.failOnDuplicate = true;
        } else {
            this.failOnDuplicate = false;
        }
        this.hash = headerOrCgi(YandexHeaders.ZOO_HASH, null);
    }

    public ProxySession session() {
        return session;
    }

    public boolean headerOrCgi(
        final String name,
        final boolean defaultValue)
        throws BadRequestException
    {
        final Boolean value = headers.getBoolean(name, null);
        if (value == null) {
            return cgiParams.getBoolean(name, defaultValue);
        } else {
            return value;
        }
    }

    public String headerOrCgi(
        final String name,
        final String defaultValue)
        throws BadRequestException
    {
        final String value = headers.getString(name.toLowerCase(), null);
        if (value == null) {
            return cgiParams.getString(name, defaultValue);
        } else {
            return value;
        }
    }

    public CgiParams cgiParams() {
        return cgiParams;
    }

    public long requestStartTime() {
        return requestStartTime;
    }

    public HttpRequest request() {
        return request;
    }

    public Logger logger() {
        return logger;
    }

    public String service() {
        return service;
    }

    public String producerName() {
        return producerName;
    }

    public Long commonPrefix() {
        return commonPrefix;
    }

    public void setCommonPrefix(final Long prefix) {
        this.commonPrefix = prefix;
    }

    public boolean doWait() {
        return doWait;
    }

    public int timeout() {
        return timeout;
    }

    public boolean multiPart() {
        return multiPart;
    }

    public boolean checkDuplicate() {
        return checkDuplicate;
    }

    public boolean memoryCheckOnly() {
        return memoryCheckOnly;
    }

    public boolean failOnDuplicate() {
        return failOnDuplicate;
    }

    public String hash() {
        return hash;
    }

    public ZooLongNode positionNode() {
        return positionNode;
    }

    public void setPositionNode(final ZooLongNode positionNode) {
        this.positionNode = positionNode;
    }

    public byte[] payload() {
        return payload;
    }

    public void setPayload(final byte[] payload) {
        this.payload = payload;
    }

    public void addMessage(final QueueMessage message) {
        messages.add(message);
    }

    public List<QueueMessage> messages() {
        return messages;
    }
}
