package ru.yandex.dispatcher.producer;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.dispatcher.common.ErrorMessage;
import ru.yandex.dispatcher.common.mappedvars.ZooLongNode;

public class StatusMessage {
    private final String path;
    private final byte[] data;
    private final String service;
    private final String backend;
    private final int shard;
    private final long position;
    private String stat = null;
    private ErrorMessage response = null;

    public FutureCallback<StatusMessage> callback;

    public StatusMessage(
        final String service,
        final String backend,
        final int shard,
        final long position)
    {
        this.service = service;
        this.shard = shard;
        this.backend = backend;
        this.position = position;

        this.path = '/' + service + '/' + shard + "/status/" + backend;
        this.data = Long.toString(position).getBytes();
    }

    public String service() {
        return service;
    }

    public void response(final ErrorMessage response) {
        this.response = response;
    }

    public ErrorMessage response() {
        return response;
    }

    public void setCallback(FutureCallback<StatusMessage> callback) {
        this.callback = callback;
    }

    public FutureCallback<StatusMessage> callback() {
        return callback;
    }

    public int weight() {
        return data.length + path.length() << 1;
    }

    public String stat() {
        return stat;
    }

    public String path() {
        return path;
    }

    public byte[] data() {
        return data;
    }

    public int shard() {
        return shard;
    }

    public void completed(final String stat) {
        this.stat = stat;
        callback.completed(this);
    }

    public void failed(Exception e) {
        callback.failed(e);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder();
        if (stat == null) {
            sb.append("Unsaved: ");
            sb.append(path);
            sb.append(": ");
            sb.append(position);
        } else {
            sb.append("Saved: ");
            sb.append(path);
            sb.append(", stat: ");
            sb.append(stat);
            sb.append(": ");
            sb.append(position);
        }
        return sb.toString();
    }
}
