package ru.yandex.dispatcher.producer;

import java.util.logging.Logger;

import org.apache.http.HttpException;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;

import ru.yandex.parser.uri.CgiParams;

public class StatusProxyRequest {
    private final Logger logger;
    private final String service;
    private final int shard;
    private final JsonType jsonType;
    private final boolean all;
    private final boolean searchable;
    private final boolean allowCached;

    public StatusProxyRequest(
        final Logger logger,
        final CgiParams cgiParams)
        throws HttpException
    {
        this.logger = logger;
        final String service = cgiParams.getString("service");
        final Long prefix = cgiParams.getLong("prefix", null);
        Integer shard = cgiParams.getInt("shard", null);

        if (shard == null && prefix == null) {
            throw new BadRequestException(
                "Missing parameter: &shard or &prefix");
        }
        if (shard == null) {
            shard = (int) Math.abs(prefix % SearchMap.SHARDS_COUNT);
        }
        this.service = service;
        this.shard = shard;
        this.all = cgiParams.getBoolean("all", false);
        this.jsonType = JsonTypeExtractor.NULL.extract(cgiParams);
        this.searchable = cgiParams.getBoolean("searchable", true);
        this.allowCached = cgiParams.getBoolean("allow_cached", false);
    }

    public boolean searchable() {
        return searchable;
    }

    public String service() {
        return service;
    }

    public int shard() {
        return shard;
    }

    public Logger logger() {
        return logger;
    }

    public boolean all() {
        return all;
    }

    public boolean allowCached() {
        return allowCached;
    }

    public JsonType jsonType() {
        return jsonType;
    }
}
