package ru.yandex.dispatcher.producer;

import java.io.IOException;
import java.math.BigDecimal;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.dispatcher.common.HangShardMessage;
import ru.yandex.util.timesource.TimeSource;

public class StopShardHandler extends QueueRequestHandlerBase {
    public StopShardHandler(final Producer producer) {
        super(producer);
    }

    @Override
    protected void addMessages(
        final QueueRequest request)
        throws IOException, HttpException
    {
        HangShardMessage msg =
            new HangShardMessage(TimeSource.INSTANCE.currentTimeMillis());
        BigDecimal position = producer.getPosition(request.request());
        addMessage(request, request.commonPrefix(), msg, position);
    }
}
