package ru.yandex.dispatcher.producer;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.parser.uri.CgiParams;

public class UpdateConsumerPositionHandler
    implements ProxyRequestHandler
{
    protected Producer producer;

    public UpdateConsumerPositionHandler(final Producer producer) {
        this.producer = producer;
    }

    @Override
    public void handle(final ProxySession session) throws HttpException {
        final CgiParams cgiParams = session.params();
        final String service = cgiParams.getString("service");
        final int shard = cgiParams.getInt("shard");
        final long position = cgiParams.getLong("position");
        final String backend = cgiParams.getString("backend");

        final StatusMessage message =
            new StatusMessage(
                service,
                backend,
                shard,
                position);

        message.setCallback(new HttpResponseCallback(session));

        producer.updatePositions(message);
    }

    private static class HttpResponseCallback
        extends AbstractProxySessionCallback<StatusMessage>
    {
        public HttpResponseCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final StatusMessage message) {
            if (message.response() != null) {
                session.response(
                    message.response().getHttpCode(),
                    message.response().getErrorString());
            } else {
                session.response(HttpStatus.SC_OK);
            }
        }
    }
}
