package ru.yandex.dispatcher.producer;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.dispatcher.common.BooleanCallback;
import ru.yandex.dispatcher.common.ZooException;
import ru.yandex.dispatcher.common.ZooNoNodeException;
import ru.yandex.dispatcher.common.connection.ZooConnection;

public class ZooUtil {
    private ZooUtil() {
    }

    public static void createPath(
        final ZooConnection conn,
        final String path,
        final FutureCallback<Void> callback)
    {
        final BooleanCallback createPathCallback = new BooleanCallback() {
            @Override
            public void dataImpl(Boolean b) {
                callback.completed(null);
            }
            @Override
            public void dataChangedImpl() {
            }
            @Override
            public void errorImpl(ZooException e) {
                if (e instanceof ZooNoNodeException) {
                    int slash = path.lastIndexOf('/');
                    if (slash == -1 || slash == 0) {
                        callback.failed(e);
                        return;
                    } else {
                        String parent = path.substring(0, slash);
                        FutureCallback<Void> retry =
                            new FutureCallback<Void>() {
                                @Override
                                public void completed(final Void v) {
                                    callback.completed(null);
                                }
                                @Override
                                public void failed(final Exception e) {
                                    callback.failed(e);
                                }
                                @Override
                                public void cancelled() {
                                }
                            };
                        createPath(conn, parent, retry);
                    }
                } else {
                    callback.failed(e);
                }
            }
        };
        //parents are only valid for persistent nodes
        conn.createNode(path, null, true, createPathCallback);
    }
}
