package ru.yandex.dispatcher.producer.json;

import java.io.IOException;

import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.ParseException;

public class BadHandler implements ContentHandler, ParseFailer {
    private final ParseFailer failer;

    public BadHandler(ParseFailer failer) {
        this.failer = failer;
    }

    @Override
    public ParseException fail() {
        return failer.fail();
    }

    @Override
    public ParseException fail(Throwable cause) {
        return failer.fail(cause);
    }

    @Override
    public void startJSON() throws IOException, ParseException {
        throw fail();
    }

    @Override
    public void endJSON() throws IOException, ParseException {
        throw fail();
    }

    @Override
    public boolean startObject() throws IOException, ParseException {
        throw fail();
    }

    @Override
    public boolean endObject() throws IOException, ParseException {
        throw fail();
    }

    @Override
    public boolean startObjectEntry(String key)
        throws IOException, ParseException
    {
        throw fail();
    }

    @Override
    public boolean endObjectEntry() throws IOException, ParseException {
        throw fail();
    }

    @Override
    public boolean startArray() throws IOException, ParseException {
        throw fail();
    }

    @Override
    public boolean endArray() throws IOException, ParseException {
        throw fail();
    }

    @Override
    public boolean primitive(Object value) throws IOException, ParseException {
        throw fail();
    }
}

