package ru.yandex.dispatcher.producer.json;

import java.io.IOException;

import org.json.simple.parser.ParseException;

public class BodyHandler extends BadHandler {
    private final HandlersManager manager;
    private final PrefixExtractor extractor;
    private int depth = 0;

    public BodyHandler(HandlersManager manager, PrefixExtractor extractor) {
        super(manager);
        this.manager = manager;
        this.extractor = extractor;
    }

    @Override
    public boolean startObjectEntry(String key)
        throws IOException, ParseException
    {
        if (depth == 0) {
            if (key.equals("prefix")) {
                manager.push(new PrefixHandler(manager, extractor));
                return true;
            }
        }
        ++depth;
        return true;
    }

    @Override
    public boolean endObjectEntry() throws ParseException {
        if (depth == 0) {
            throw fail();
        } else {
            --depth;
        }
        return true;
    }

    @Override
    public boolean startObject() {
        ++depth;
        return true;
    }

    @Override
    public boolean endObject() throws IOException, ParseException {
        if (depth == 0) {
            manager.pop();
            return false;
        } else {
            --depth;
            return true;
        }
    }

    @Override
    public boolean startArray() {
        ++depth;
        return true;
    }

    @Override
    public boolean endArray() throws ParseException {
        if (depth == 0) {
            throw fail();
        } else {
            --depth;
        }
        return true;
    }

    @Override
    public boolean primitive(Object o) {
        return true;
    }
}

