package ru.yandex.dispatcher.producer.json;

import org.json.simple.parser.ParseException;
import org.json.simple.parser.JSONParser;

public final class DefaultFailer implements ParseFailer {
    private final JSONParser parser;

    public DefaultFailer(JSONParser parser) {
        this.parser = parser;
    }

    @Override
    public ParseException fail() {
        return new ParseException(parser.getPosition(),
            ParseException.ERROR_UNEXPECTED_TOKEN, this.getClass().getName());
    }

    @Override
    public ParseException fail(Throwable cause) {
        ParseException e = new ParseException(parser.getPosition(),
            ParseException.ERROR_UNEXPECTED_TOKEN, this.getClass().getName());
        e.initCause(cause);
        return e;
    }
}

