package ru.yandex.dispatcher.producer.json;

import java.io.IOException;

import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.ParseException;

public class DefaultHandler extends BadHandler {
    private HandlersManager manager;

    public DefaultHandler(HandlersManager manager) {
        super(manager);
        this.manager = manager;
    }

    public void push(ContentHandler handler) {
        manager.push(handler);
    }

    public void pop() throws ParseException {
        try {
            manager.pop();
        } catch (Exception e) {
            throw fail(e);
        }
    }

    HandlersManager getManager() {
        return manager;
    }

    @Override
    public boolean endObjectEntry() throws IOException, ParseException {
        pop();
        return true;
    }
}

