package ru.yandex.dispatcher.producer.json;

import java.io.IOException;
import java.util.Stack;

import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.ParseException;

public class HandlersManager extends Stack<ContentHandler>
    implements ContentHandler, ParseFailer
{
    private final ParseFailer failer;

    public HandlersManager(ParseFailer failer) {
        this.failer = failer;
    }

    @Override
    public ParseException fail() {
        return failer.fail();
    }

    @Override
    public ParseException fail(Throwable cause) {
        return failer.fail(cause);
    }

    @Override
    public void startJSON() throws IOException, ParseException {
        try {
            peek().startJSON();
        } catch (ParseException e) {
            throw e;
        } catch (Exception e) {
            throw fail(e);
        }
    }

    @Override
    public void endJSON() throws IOException, ParseException {
        try {
            peek().endJSON();
        } catch (ParseException e) {
            throw e;
        } catch (Exception e) {
            throw fail(e);
        }
    }

    @Override
    public boolean startObject() throws IOException, ParseException {
        try {
            return peek().startObject();
        } catch (ParseException e) {
            throw e;
        } catch (Exception e) {
            throw fail(e);
        }
    }

    @Override
    public boolean endObject() throws IOException, ParseException {
        try {
            return peek().endObject();
        } catch (ParseException e) {
            throw e;
        } catch (Exception e) {
            throw fail(e);
        }
    }

    @Override
    public boolean startObjectEntry(String key)
        throws IOException, ParseException
    {
        try {
            return peek().startObjectEntry(key);
        } catch (ParseException e) {
            throw e;
        } catch (Exception e) {
            throw fail(e);
        }
    }

    @Override
    public boolean endObjectEntry() throws IOException, ParseException {
        try {
            return peek().endObjectEntry();
        } catch (ParseException e) {
            throw e;
        } catch (Exception e) {
            throw fail(e);
        }
    }

    @Override
    public boolean startArray() throws IOException, ParseException {
        try {
            return peek().startArray();
        } catch (ParseException e) {
            throw e;
        } catch (Exception e) {
            throw fail(e);
        }
    }

    @Override
    public boolean endArray() throws IOException, ParseException {
        try {
            return peek().endArray();
        } catch (ParseException e) {
            throw e;
        } catch (Exception e) {
            throw fail(e);
        }
    }

    @Override
    public boolean primitive(Object value) throws IOException, ParseException {
        try {
            return peek().primitive(value);
        } catch (ParseException e) {
            throw e;
        } catch (Exception e) {
            throw fail(e);
        }
    }
}

