package ru.yandex.dispatcher.producer.json;

import org.json.simple.parser.ParseException;

public class PrefixHandler extends DefaultHandler {
    private PrefixExtractor extractor;

    public PrefixHandler(HandlersManager manager, PrefixExtractor extractor) {
        super(manager);
        this.extractor = extractor;
    }

    @Override
    public boolean primitive(Object value) throws ParseException {
        if (value == null) {
            throw fail();
        } else if (value instanceof String) {
            try {
                extractor.setPrefix(Long.parseLong((String)value));
            } catch (Exception e) {
                throw fail(e);
            }
        } else if (value instanceof Number) {
            extractor.setPrefix(((Number)value).longValue());
        } else {
            throw fail();
        }
        return false;
    }
}

