package ru.yandex.dispatcher.producer.statusreader;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.AsyncCallback.ChildrenCallback;
import org.apache.zookeeper.AsyncCallback.DataCallback;
import org.apache.zookeeper.AsyncCallback.StatCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.Watcher.Event.KeeperState;
import org.apache.zookeeper.ZooDefs.Ids;
import org.apache.zookeeper.ZooKeeper;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.dispatcher.producer.SearchMap;

public class ServiceConsumer
{
    private String addr;
    private String zkAddr;
    private int minShard;
    private int maxShard;
    private Shard[] shards;
    private ZooKeeperPool[] zooKeepers;
    private ExecutorService workExecutor;

    private StatusConsumer parent;
    private SearchMap searchMap;
    private int timeout;
    private String service;
    private int workers;
    private PrefixedLogger logger;

    public ServiceConsumer( StatusConsumer parent, SearchMap searchMap, String service, String zkAddr, int workers, int timeout, PrefixedLogger logger )
    {
        this.parent = parent;
        this.searchMap = searchMap;
        this.timeout = timeout;
        this.zkAddr = zkAddr;
        this.workers = workers;
        this.service = service;
        this.shards = null;
        this.logger = logger;
    }

    public void start()
    {
        shards = new Shard[maxShard - minShard + 1];

	zooKeepers = new ZooKeeperPool[workers];
	for( int i = 0; i < workers; i++ )
	{
	    zooKeepers[i] = new ZooKeeperPool( this, i, timeout, logger, false );
	}

        ZooKeeperDSN dsn = new ZooKeeperDSN(zkAddr, timeout);
	for( int i = minShard; i <= maxShard; i++ )
	{
	    shards[i-minShard] = new Shard( searchMap, service, i, zooKeepers[i % workers], dsn, this, logger );
	}
	resetAllShards();
    }

    public void expandShards( int min, int max )
    {
        if( shards != null ) throw new RuntimeException( "Can't expand shards in ServiceConsumer<"+service+">: consumer already started" );
        if( minShard > min ) minShard = min;
        if( maxShard < max ) maxShard = max;
    }

    public synchronized void resetAllShards()
    {
        for( int i = 0; i < shards.length; i++ )
        {
            Shard s = shards[i];
	    s.reset();
	}
    }

    public void dispatchNode( Node node, Shard shard )
    {
        logger.fine("Status received for: " + node.path);
//        workExecutor.submit( new ProcessNodeTask(node, shard) );
    }

    public void disconnected( ZooKeeperConnection zkc, int num )
    {
//        resetShardsForZk( zkc );
    }

    public synchronized void resetShardsForZk( ZooKeeperConnection zkc )
    {
        for( int i = 0; i < shards.length; i++ )
        {
            Shard s = shards[i];
            if( s.zkc == zkc )
            {
                s.reset();
            }
	}
    }

    public void notifyStatus( Shard shard, String backend, long queueId )
    {
        parent.notifyStatus( service, shard.shardNo, backend, queueId );
    }

    public String[] getFreshestBackends( int shard ) throws NewShardException //TODO: fix this
    {
        if( shard > maxShard || shard < minShard )
        {
    	    logger.severe( "ServiceConsumer.getFreshestBackends( " + shard + "): shard is outside of limits: " + minShard + "/" + maxShard );
    	    return null;
    	}
        shard -= minShard;
        Shard s = shards[shard];
        return s.getFreshestBackends();
    }

    public String[] getFreshestBackendsCached( int shard ) throws NewShardException //TODO: fix this
    {
        if( shard > maxShard || shard < minShard )
        {
    	    logger.severe( "ServiceConsumer.getFreshestBackends( " + shard + "): shard is outside of limits: " + minShard + "/" + maxShard );
    	    return null;
    	}
        shard -= minShard;
        Shard s = shards[shard];
        return s.getFreshestBackendsCached();
    }
}
