package ru.yandex.dispatcher.producer.statusreader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.AsyncCallback.ChildrenCallback;
import org.apache.zookeeper.AsyncCallback.DataCallback;
import org.apache.zookeeper.AsyncCallback.StatCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.Watcher.Event.KeeperState;
import org.apache.zookeeper.ZooDefs.Ids;
import org.apache.zookeeper.ZooKeeper;

import ru.yandex.dispatcher.producer.SearchMap;
import ru.yandex.util.timesource.TimeSource;

public class Shard //implements AsyncCallback.StatCallback, AsyncCallback.ChildrenCallback, AsyncCallback.DataCallback, AsyncCallback.VoidCallback, Watcher
{
    public int shardNo;
    public long count = -1;
    public String statusPath;
    private ZooKeeperPool zooPool;
    public ZooKeeperConnection zkc;
    private ZooKeeperDSN dsn;
    private ServiceConsumer consumer;
    private String service;
    private Logger logger;
    private SearchMap searchMap;

    private HashMap<String, Long> backends = new HashMap<String, Long>();
    private HashSet<String> backendPath = new HashSet<String>();

    private StatusPathLister statusPathLister = new StatusPathLister();
    private StatusPathWaiter statusPathWaiter = new StatusPathWaiter();
    private StatusNodeReader statusNodeReader = new StatusNodeReader();
    private StatusNodeWaiter statusNodeWaiter = new StatusNodeWaiter();
    private Object currentHandler;
    private long handlerOp = 0;
    private boolean newShard = false;
    private boolean wasConnected = false;

    public Shard( SearchMap searchMap, String service, int num, ZooKeeperPool zooPool, ZooKeeperDSN dsn, ServiceConsumer consumer, Logger logger )
    {
	shardNo = num;
	this.searchMap = searchMap;
	this.zooPool = zooPool;
	this.dsn = dsn;
	this.consumer = consumer;
	this.service = service;
	this.logger = logger;
	statusPath = "/" + service + "/" + shardNo + "/status";
	unshare(statusPath);
    }

    private static String unshare(final String str) {
        final StringBuilder sb = new StringBuilder(str.length());
        sb.append(str);
        return new String(sb);
    }

    @Override
    public final int hashCode()
    {
	return shardNo;
    }

    @Override
    public final boolean equals( Object o )
    {
	Shard other = (Shard)o;
	return shardNo == other.shardNo;
    }

    private synchronized ZooKeeper getZk()
    {
        if( zkc != null && !zkc.isConnected() )
        {
            zkc.close();
            zkc = null;
        }
        String address = dsn.currentAddress();
        int t = 0;
        while( zkc == null )
        {
            if( t >= dsn.serverCount() )
            {
                try
                {
                    Thread.sleep( 1000 );
                }
                catch( Exception e )
                {
                }
            }
            zkc = zooPool.getConnection( address );
            t++;
            logger.severe( "Shard<" + shardNo +">: getZk(): connecting to: " + address );
            if( zkc == null || zkc != null && !zkc.isConnected() )
            {
                logger.severe( "Shard<" + shardNo +">: getZk(): can't connect to: " + address );
                zkc = null;
                address = dsn.nextAddress();
            }
        }
        wasConnected = true;
        return zkc.zk;
    }

    public void reset()
    {
        statusPathLister.list();
    }

    private class StatusPathWaiter implements AsyncCallback.StatCallback, Watcher
    {
        public StatusPathWaiter()
        {
        }

        public void waitFor( String b )
        {
            synchronized( Shard.this )
            {
                currentHandler = this;
            }
            ZooKeeper zk = getZk();
            zk.exists( b, this, this, null );
        }

        //GetData handler
        @Override
        public void processResult(int rc, String path, Object ctx, Stat stat)
        {
            synchronized( Shard.this )
            {
                if( currentHandler != this ) return;
            }
            if( rc == 0 )
            {
                if( !statusPath.equals(path) )
                {
                    logger.severe("Shard<"+shardNo+">.StatusPathWaiter unhandled processResult for path: " + path + ": unknown path");
                    return;
                }
                statusPathLister.list();
            }
            else if( rc == KeeperException.Code.NONODE.intValue() )
            {
                logger.severe("Shard<"+shardNo+">.StatusPathWaiter processResult: Node <"+path+"> does not exists. Waiting for watch trigger" );
            }
            else
            {
                logger.severe("Shard<"+shardNo+">.StatusPathWaiter processResult unknown error: " + rc );
                waitFor( statusPath );
            }
        }

        @Override
        public synchronized void process(WatchedEvent event)
        {
            synchronized( Shard.this )
            {
                if( currentHandler != this ) return;
            }
	    logger.fine("Shard<"+shardNo+">.StatusPathWaiter watched event " + event);
	    if( event.getState() == KeeperState.SyncConnected )
	    {
	        if( event.getType() == Watcher.Event.EventType.NodeCreated )
	        {
	            statusPathLister.list();
	        }
	        else
	        {
	            logger.severe("Shard<"+shardNo+">.StatusPathWaiter unhandled event " + event);
	        }
	    }
	    else if( event.getState() == KeeperState.Expired || event.getState() == KeeperState.Disconnected )
	    {
	        waitFor( statusPath );
	    }
        }
    }

    private class StatusPathLister implements AsyncCallback.ChildrenCallback, Watcher
    {
        public StatusPathLister()
        {
        }

        public void list()
        {
            synchronized( Shard.this )
            {
                currentHandler = this;
            }
            ZooKeeper zk = getZk();
            zk.getChildren( statusPath, this, this, null );
            logger.fine( "Shard<" + shardNo + "> listing" );
        }

        public void watchedList( Object ctx )
        {
            ZooKeeper zk = getZk();
            zk.getChildren( statusPath, this, this, ctx );
        }

        //getChildren handler
        @Override
        public synchronized void processResult(int rc, String path, Object ctx, List<String> children)
        {
            synchronized( Shard.this )
            {
                if( currentHandler != this && currentHandler != statusNodeReader && currentHandler != statusNodeWaiter ) return;
//                if( currentHandler != this ) return;
            }
            if( rc == 0 )
            {
                if( !statusPath.equals(path) )
                {
                    logger.severe("Shard<"+shardNo+">.StatusPathLister unhandled processResult for path: " + path );
                    return;
                }
                if( children == null || children.size() == 0 )
                {
        	    synchronized( Shard.this )
        	    {
            		newShard = true;
            	    }
                    logger.severe("Shard<"+shardNo+">.StatusPathLister children == null in processResult for path: " + path + ". Waiting for watch trigger" );
                    return;
                }
		synchronized( Shard.this )
        	{
            	    newShard = false;
            	}
                synchronized( backendPath )
                {
                    for( String c : children )
                    {
                        String bp = statusPath + '/' + c;
                        boolean added = backendPath.add(bp.intern());
/*                        if( currentHandler == this )
                        {
                            statusNodeReader.read( bp );
                        }
                        else
                        {
                            if( added )
                            {
                                statusNodeReader.read( bp );
                            }
                        }
*/
                        statusNodeReader.readAll();
                    }
                }
                if( ctx != null )
                {
                    List<String> prevChildren = (List<String>)ctx;
                    if( prevChildren.equals(children) )
                    {
                        //no new childs. Waiting for watch
                        return;
                    }
                    else
                    {
                        watchedList( children );
                    }
                }
                else
                {
                    watchedList( children );
                }
            }
            else if( rc == KeeperException.Code.NONODE.intValue() )
            {
                logger.severe("Shard<"+shardNo+">.StatusPathLister processResult: Node <"+path+"> does not exists. Waiting" );
		synchronized( Shard.this )
        	{
            	    newShard = true;
            	}
                statusPathWaiter.waitFor( path );
            }
            else
            {
                logger.severe("Shard<"+shardNo+">.StatusPathLister processResult unknown error: " + rc );
                list();
            }
        }

        @Override
        public synchronized void process(WatchedEvent event)
        {
            synchronized( Shard.this )
            {
                if( currentHandler != this && currentHandler != statusNodeReader && currentHandler != statusNodeWaiter ) return;
            }
	    logger.severe("Shard<"+shardNo+">.StatusPathLister watched event " + event);
	    if( event.getState() == KeeperState.SyncConnected )
	    {
	        if( event.getType() == Watcher.Event.EventType.NodeChildrenChanged )
	        {
	            watchedList( null );
	        }
	        else
	        {
	            logger.severe("Shard<"+shardNo+">.StatusPathLister unhandled event " + event);
	        }
	    }
	    else if( event.getState() == KeeperState.Expired || event.getState() == KeeperState.Disconnected )
	    {
	        list();
	    }
        }
    }


    private class StatusNodeWaiter implements AsyncCallback.StatCallback, Watcher
    {
        public StatusNodeWaiter()
        {
        }

        public void waitAll()
        {
            synchronized( Shard.this )
            {
                currentHandler = this;
            }
            ZooKeeper zk = getZk();
            synchronized( backendPath )
            {
                for( String b : backendPath )
                {
                    zk.exists( b, this, this, null );
                }
            }
        }

        public void waitFor( String b )
        {
            synchronized( Shard.this )
            {
                currentHandler = this;
            }
            ZooKeeper zk = getZk();
            zk.exists( b, this, this, null );
        }

        //GetData handler
        @Override
        public void processResult(int rc, String path, Object ctx, Stat stat)
        {
            synchronized( Shard.this )
            {
                if( currentHandler != this ) return;
            }
            if( rc == 0 )
            {
                synchronized( backendPath )
                {
                    if( !backendPath.contains(path) )
                    {
                        logger.severe("Shard<"+shardNo+">.StatusNodeWaiter unhandled processResult for path: " + path );
                        return;
                    }
                }
                statusNodeReader.read( path );
            }
            else if( rc == KeeperException.Code.NONODE.intValue() )
            {
                logger.severe("Shard<"+shardNo+">.StatusNodeWaiter processResult: Node <"+path+"> does not exists. Waiting for watch trigger" );
    		synchronized( Shard.this )
		{
            	    newShard = true;
            	}
            }
            else
            {
                logger.severe("Shard<"+shardNo+">.StatusNodeWaiter processResult unknown error: " + rc );
                waitAll();
            }
        }

        @Override
        public synchronized void process(WatchedEvent event)
        {
            synchronized( Shard.this )
            {
                if( currentHandler != this ) return;
            }
	    logger.fine("Shard<"+shardNo+">.StatusNodeWaiter watched event " + event);
	    if( event.getState() == KeeperState.SyncConnected )
	    {
	        if( event.getType() == Watcher.Event.EventType.NodeCreated )
	        {
	            statusNodeReader.read( event.getPath() );
	        }
	        else
	        {
	            logger.severe("Shard<"+shardNo+">.StatusNodeReader unhandled event " + event);
	        }
	    }
	    else if( event.getState() == KeeperState.Expired || event.getState() == KeeperState.Disconnected )
	    {
	        waitAll();
	    }
        }
    }

    private class StatusNodeReader implements AsyncCallback.DataCallback, Watcher
    {
        public StatusNodeReader()
        {
        }

        public void readAll()
        {
            synchronized( Shard.this )
            {
                currentHandler = this;
            }
            ZooKeeper zk = getZk();
            for( String b : backendPath )
            {
                zk.getData( b, this, this, null );
            }
        }

        public void read( String b )
        {
            synchronized( Shard.this )
            {
                currentHandler = this;
            }
            ZooKeeper zk = getZk();
            zk.getData( b, this, this, null );
        }

        //GetData handler
        @Override
        public synchronized void processResult(int rc, String path, Object ctx, byte[] data, Stat stat)
        {
            synchronized( Shard.this )
            {
                if( currentHandler != this ) return;
            }
            if( rc == 0 )
            {
                synchronized( backendPath )
                {
                    if( !backendPath.contains(path) )
                    {
                        logger.severe("Shard<"+shardNo+">.StatusNodeReader unhandled processResult for path: " + path );
                        return;
                    }
                }
                if( data == null )
                {
                    logger.severe("Shard<"+shardNo+">.StatusNodeReader data == null in processResult for path: " + path );
                    return;
                }
                long pos = 0;
                String dataStr = new String(data);
                try
                {
                    pos = Long.parseLong( dataStr );
                }
                catch( Exception e )
                {
                    logger.severe("Shard<"+shardNo+">.StatusNodeReader processResult can't parse long from \"" + dataStr + "\" for path: " + path );
                }
                String backendName =
                    path.substring(path.lastIndexOf('/') + 1).intern();
                Long currentPos;
                synchronized( backends )
                {
                    currentPos = backends.get( backendName );
                    if( currentPos == null || currentPos < pos )
                    {
                        backends.put( backendName, pos );
                        logger.fine( "Shard<"+shardNo+">.StatusNodeReader: new pos: " + pos + " for " + backendName );
                        currentPos = pos;
                    }
                }
                wasConnected = true;
                consumer.notifyStatus( Shard.this, backendName, currentPos );
                synchronized( Shard.this )
                {
                    if( zkc != null ) zkc.updateLastUpdate();
                    newShard = false;
                }
            }
            else if( rc == KeeperException.Code.NONODE.intValue() )
            {
                logger.severe("Shard<"+shardNo+">.StatusNodeReader processResult: Node <"+path+"> does not exists. Waiting" );
                statusNodeWaiter.waitFor( path );
            }
            else
            {
                logger.severe("Shard<"+shardNo+">.StatusNodeReader processResult unknown error: " + rc );
                readAll();
            }
        }

        @Override
        public synchronized void process(WatchedEvent event)
        {
            synchronized( Shard.this )
            {
                if( currentHandler != this ) return;
            }
	    logger.fine("Shard<"+shardNo+">.StatusNodeReader watched event " + event);
	    if( event.getState() == KeeperState.SyncConnected )
	    {
	        if( event.getType() == Watcher.Event.EventType.NodeDataChanged )
	        {
	            read( event.getPath() );
	        }
	        else
	        {
	            logger.severe("Shard<"+shardNo+">.StatusNodeReader unhandled event " + event);
	        }
	    }
	    else if( event.getState() == KeeperState.Expired || event.getState() == KeeperState.Disconnected )
	    {
	        readAll();
	    }
        }
    }

    public synchronized String[] getFreshestBackends() throws NewShardException //TODO: fix this
    {
	if( newShard )
	{
	    logger.fine("Shard<"+shardNo+">.getFreshestBackends newShard, throwing exception." );
	    throw new NewShardException();
	}
	else
	{
	    logger.fine("Shard<"+shardNo+">.getFreshestBackends newShard=false" );
	}

	long maxPos = -1;
	ArrayList<String> ret = null;//new ArrayList<String>( backends.size() );
        if( zkc == null || 
            !zkc.isConnected() ||
            (TimeSource.INSTANCE.currentTimeMillis() - zkc.lastUpdate() > 2000 && zooPool.autoSync())
        )
        {
	    logger.fine("Shard<"+shardNo+">.getFreshestBackends ZooKeeper connection is expired: " + zkc + ", " + (zkc != null ? zkc.isConnected() : "null") + ", " + (zkc == null ? "null" : (TimeSource.INSTANCE.currentTimeMillis() - zkc.lastUpdate())) );
    	    return null;
    	}

        for( Map.Entry<String,Long> entry : backends.entrySet() )
        {
            if( !searchMap.isBackendSearchable(service, shardNo, entry.getKey()) )
                continue;
            if( maxPos < entry.getValue() )
            {
                maxPos = entry.getValue();
                if( ret == null ) ret = new ArrayList<String>( backends.size() );
                else
                {
                    ret.clear();
                }
                ret.add( entry.getKey() );
            }
            else if( maxPos == entry.getValue() )
            {
                if( ret == null ) ret = new ArrayList<String>( backends.size() );
                ret.add( entry.getKey() );
            }
        }
        if( ret == null )
        {
	    logger.fine("Shard<"+shardNo+">.getFreshestBackends ret=null" );
            return null;
        }
        return ret.toArray( new String[ret.size()] );
    }

    public synchronized String[] getFreshestBackendsCached() throws NewShardException //TODO: fix this
    {
	if( newShard )
	{
	    logger.fine("Shard<"+shardNo+">.getFreshestBackends newShard, throwing exception." );
	    throw new NewShardException();
	}
	else
	{
	    logger.fine("Shard<"+shardNo+">.getFreshestBackends newShard=false" );
	}

	long maxPos = -1;
	ArrayList<String> ret = null;//new ArrayList<String>( backends.size() );
        if( !wasConnected )
        {
	    logger.fine("Shard<"+shardNo+">.getFreshestBackends ZooKeeper connection is expired: " + zkc + ", " + (zkc != null ? zkc.isConnected() : "null") + ", " + (zkc == null ? "null" : (TimeSource.INSTANCE.currentTimeMillis() - zkc.lastUpdate())) );
    	    return null;
    	}
        for( Map.Entry<String,Long> entry : backends.entrySet() )
        {
            if( !searchMap.isBackendSearchable(service, shardNo, entry.getKey()) )
                continue;
            if( maxPos < entry.getValue() )
            {
                maxPos = entry.getValue();
                if( ret == null ) ret = new ArrayList<String>( backends.size() );
                else
                {
                    ret.clear();
                }
                ret.add( entry.getKey() );
            }
            else if( maxPos == entry.getValue() )
            {
                if( ret == null ) ret = new ArrayList<String>( backends.size() );
                ret.add( entry.getKey() );
            }
        }
        if( ret == null )
        {
	    logger.fine("Shard<"+shardNo+">.getFreshestBackends ret=null" );
            return null;
        }
        return ret.toArray( new String[ret.size()] );
    }
}
