package ru.yandex.dispatcher.producer.statusreader;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.AsyncCallback.ChildrenCallback;
import org.apache.zookeeper.AsyncCallback.DataCallback;
import org.apache.zookeeper.AsyncCallback.StatCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.Watcher.Event.KeeperState;
import org.apache.zookeeper.ZooDefs.Ids;
import org.apache.zookeeper.ZooKeeper;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.util.timesource.TimeSource;

public class ZooKeeperConnection implements Watcher
{
    public ZooKeeper zk;
    public long lastSync;

    private final String zkAddr;
    private final ServiceConsumer consumer;
    private final int num;
    private final int timeout;
    private final PrefixedLogger logger;

    private volatile boolean connected = false;
    private volatile long lastUpdate;
    private boolean closed = false;

    public ZooKeeperConnection(
        final String zkAddr,
        final ServiceConsumer consumer,
        final int num,
        final int timeout,
        final PrefixedLogger logger)
    {
        this.zkAddr = zkAddr;
        this.consumer = consumer;
        this.num = num;
        this.timeout = timeout;
        this.logger = logger;
    }

    public void updateLastUpdate()
    {
        lastUpdate = TimeSource.INSTANCE.currentTimeMillis();
    }

    public long lastUpdate()
    {
        return lastUpdate;
    }

    public synchronized void sync()
    {
	if( zk == null ) return;
        zk.sync( "/", null, null );
        updateLastUpdate();
    }

    public synchronized void connect()
    {
        try
        {
            zk = new ZooKeeper(zkAddr, timeout, this, logger);
	    for( int i = 0; i < 50; i++ )
	    {
	        if( zk.getState().isConnected() )
	        {
	            connected = true;
	            return;
	        }
	        Thread.sleep( 100 );
	    }
	    if( !zk.getState().isConnected() )
	    {
	        zk.close();
	        closed = true;
	    }
	    else
	    {
	        connected = true;
	    }
	}
	catch( java.lang.InterruptedException ign )
	{
	    logger.log( Level.FINE, "ZooKeeperConnection.connect: InterrupedException", ign );
	}
	catch( IOException e )
	{
	    logger.log( Level.FINE, "ZooKeeperConnection.connect: IOException", e );
	}
    }

    public synchronized void close() {
        if (!closed) {
            closed = true;
            zk.close();
        }
    }

    public boolean isConnected() {
        return connected;
    }

    @Override
    public synchronized void process(WatchedEvent event)
    {
        logger.fine("Watched event from <"+zkAddr+">: " + event);
    	if( event.getState() != KeeperState.SyncConnected )
    	{
    	    connected = false;
    	    close();
    	    consumer.disconnected( this, num );
	}
    }

}
