package ru.yandex.dispatcher.producer.statusreader;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.AsyncCallback.ChildrenCallback;
import org.apache.zookeeper.AsyncCallback.DataCallback;
import org.apache.zookeeper.AsyncCallback.StatCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.Watcher.Event.KeeperState;
import org.apache.zookeeper.ZooDefs.Ids;
import org.apache.zookeeper.ZooKeeper;

public class ZooKeeperDSN //implements Comparable
{
private LinkedList<String> addresses;
private String connectString;
private String address;
private int timeout;

    public ZooKeeperDSN( String connectString, int timeout )
    {
        this.connectString = connectString;
        this.timeout = timeout;
        String[] a = connectString.split(",");
        addresses = new LinkedList<String>();
        String localHostName;
        try
        {
    	    localHostName = java.net.InetAddress.getLocalHost().getHostName();
    	}
    	catch( java.net.UnknownHostException e )
    	{
    	    localHostName = null;
    	}

        String priorityHost = null;
        for( String addr : a )
        {
            int slash = addr.indexOf('/');
            if (slash != -1) {
                addr = addr.substring(0, slash);
            }
    	    if( localHostName != null && addr.startsWith(localHostName) )
    	    {
    		priorityHost = addr;
    		continue;
    	    }
            addresses.add(addr);
        }
        if( priorityHost != null ) addresses.add( 0, priorityHost );
        for( String address : addresses )
        {
    	    ZooKeeperPool.isAlive( address );
        }
    }

    public synchronized String nextAddress()
    {
        address = addresses.remove(0);
        addresses.add( address );
        return address;
    }

    public synchronized String currentAddress()
    {
        if( address == null ) nextAddress();
        return address;
    }

    public int serverCount()
    {
        return addresses.size();
    }

    public int timeout()
    {
        return timeout;
    }

    public List<String> addresses()
    {
	return addresses;
    }

    public String connectString()
    {
        return connectString;
    }
}
