#!/bin/bash
set -exo pipefail

source config.sh

CRON_DIR=./$CONFIG_DIR/cron.d

function runJob {
    set +e -x
    source $job || true

    START_DELAY=${START_DELAY:-30}
    INTERVAL=${INTERVAL:-30}
    sleep $START_DELAY
    while true; do
        echo $(date)" Starting job: $job" >&2
        $job
        echo $(date)" Ended job: $job" >&2
        sleep $INTERVAL
    done
}

declare -A PIDS
while true;
do
    if [ -d $CRON_DIR ]; then
        while read -r job;
        do
            if [ "$job" == "" ]; then
                continue
            fi
            if [ ${PIDS[$job]+_} ]; then
                if kill -0 ${PIDS[$job]}; then
                    #running
                    continue;
                fi
            fi
            NAME=$(basename $job)
            LOG="cron_"$NAME".out"
            ERR="cron_"$NAME".err"
            runJob $script >$LOG 2>$ERR &
            PIDS[$job]=$!
        done <<< "$(find $CRON_DIR/ -type f -executable)"
        sleep 10
    else
        sleep 300
    fi
done
