#!/bin/bash
set -exo pipefail

source config.sh

source classpath.sh

if [ "$MEM_LIMIT" != "" ]; then
    export MEMORY_LIMIT=$((MEM_LIMIT/100*80))
else
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | awk '{print int($1*0.8)}')
    if [ "$MEMORY_LIMIT" == "0" ]; then
        export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .memory_limit' | awk '{print int($1*0.8)}')
    fi
fi

if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk '{print int($1)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
    if [ "$CPU_CORES" == "" ]; then
        export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .cpu_limit' | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
    fi
fi

if jdk/bin/java -version 2>&1 | fgrep -q -e OpenJ9 -e Ibm -e IBM; then
    GC_ARGS="-Xmx$MEMORY_LIMIT -Xgcpolicy:gencon -Xgcthreads$CPU_CORES -verbose:gc -Xverbosegclog:/dev/shm/gclogs/gc#.log,10,10000"
else
    GC_ARGS="
    -Xmx$MEMORY_LIMIT
    -XX:+PrintGC
    -XX:+PrintGCDetails
    -XX:+UnlockExperimentalVMOptions
    -verbose:gc
    -XX:+UseShenandoahGC
    -XX:ConcGCThreads=1
    -XX:ShenandoahGCMode=traversal
    -XX:-ShenandoahAlwaysClearSoftRefs
    -XX:ShenandoahAllocationThreshold=10
    -XX:ShenandoahGuaranteedGCInterval=30000
    -XX:ParallelGCThreads=$CPU_CORES
    -XX:+UnlockDiagnosticVMOptions
    -Xloggc:/dev/shm/gclogs/gc.log
    "
fi

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
ZOO_ARGS="
-Dorg.apache.commons.logging.Log=org.apache.commons.logging.impl.SimpleLog
-Dorg.apache.commons.logging.simplelog.showdatetime=false
-Dorg.apache.commons.logging.simplelog.log.org.apache.http=OFF
-Dorg.apache.commons.logging.simplelog.log.org.apache.http.wire=OFF
-Dzookeeper.log.dir=/db/bsconfig/webcache/%(BSCONFIG_INAME)s/logs/
-Dzookeeper.log.dir=/logs/
-Dzookeeper.root.logger=INFO,ROLLINGFILE
"
exec $BSCONFIG_IDIR/jdk/bin/java \
    $JAVA_ARGS $GC_ARGS $NET_ARGS $ZOO_ARGS \
    -DBSCONFIG_IPORT=$BSCONFIG_IPORT \
    -Djava.library.path=. \
    -Djava.library.path=./dispatcher_zk_service \
    -cp $CLASSPATH ru.yandex.dispatcher.producer.Producer \
    $CONFIG_DIR/zoolooser-producer.conf

