package org.apache.zookeeper.server;

public class StringHash implements HashKey {
    private static final int BASE_OBJECT_SIZE = 40;
    public final String parentPath;
    private final String hash;

    public StringHash(final String parentPath, final String hash) {
        this.parentPath = parentPath.intern();
        this.hash = hash;
    }

    public int hashCode() {
        return hash.hashCode() + parentPath.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof StringHash) {
            return hash.equals(((StringHash)o).hash) &&
                parentPath.equals(((StringHash)o).parentPath);
        }
        return false;
    }
    public String toString() {
        return "hash" + parentPath + "/" + hash;
    }

    public void toString(final StringBuilder sb) {
        sb.setLength(0);
        sb.append("hash");
        sb.append(parentPath);
        sb.append('/');
        sb.append(hash);
    }

    public int size() {
        return BASE_OBJECT_SIZE * 3 + parentPath.length() * 2 +
            hash.length() * 2;
    }
}
