package org.apache.zookeeper.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class TreeChildSet implements ChildSet {
    private final TreeSet<String> set;

    public TreeChildSet() {
        set = new TreeSet<String>();
    }

    public boolean add(String child) {
        return set.add(child);
    }

    public boolean remove(String child) {
        return set.remove(child);
    }

    public String first() {
        return set.first();
    }

    public String last() {
        return set.last();
    }

    public String nextChild(String child) {
        Set<String> tail = set.tailSet(child);
        if (tail != null) {
            Iterator<String> iter = tail.iterator();
            if (iter.hasNext()) {
                return iter.next();
            }
        }
        return null;
    }

    public boolean contains(String child) {
        return set.contains(child);
    }

    public int size() {
        return set.size();
    }

    public List<String> getList() {
        return new ArrayList<String>(set);
    }

    public String[] toArray() {
        return set.toArray(new String[set.size()]);
    }

    @Override
    public Iterator<String> iterator() {
        return new ArrayList(set).iterator();
    }
}
