JAVA_LIBRARY()

JDK_VERSION(11)

LICENSE(Unknown)

OWNER(g:personal-search)

INCLUDE(${ARCADIA_ROOT}/mail/persdata/build/dependencies.inc)

NO_LINT()

JAVA_SRCS(SRCDIR main/java **/*.java)
JAVA_SRCS(SRCDIR main/resources **/*)
JAVA_SRCS(SRCDIR ${BINDIR}/generated **/*.java)

PEERDIR(
    contrib/java/com/github/luben/zstd-jni
    contrib/java/com/google/guava/guava
    contrib/java/commons-cli/commons-cli
    contrib/java/io/netty/netty
    contrib/java/jline/jline
    contrib/java/org/lz4/lz4-java
    contrib/java/org/slf4j/slf4j-log4j12
    mail/library/zoolooser/jute
    mail/search/search_backend
)

RUN_JAVA_PROGRAM(
    org.apache.jute.compiler.generated.Rcc -l java
    ${ARCADIA_ROOT}/mail/library/zoolooser/zoolooser/main/jute/zookeeper.jute
    IN mail/library/zoolooser/zoolooser/main/jute/zookeeper.jute
    OUT_DIR ${BINDIR}/generated
    CWD ${BINDIR}/generated
    CLASSPATH mail/library/zoolooser/jute)

# Added automatically to remove dependency on default contrib versions
DEPENDENCY_MANAGEMENT(
    contrib/java/commons-cli/commons-cli/1.4
    contrib/java/io/netty/netty/3.10.6.Final
    contrib/java/org/slf4j/slf4j-log4j12/1.8.0-beta2
)

END()
