#!/bin/bash
set -exo pipefail

export ZSTD=true
export SNAP_COUNT=4000000

export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | gawk '{print int($1*0.8)}')
export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1)}')

if [ "$LABELS_deploy_engine" = "YP_LITE" ]; then
    export MEMORY_LIMIT=$(echo $MEM_LIMIT | gawk '{print int($1*0.8)}')
    export CPU_CORES=$(echo $CPU_LIMIT | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
fi

case "$NANNY_SERVICE_ID" in
    disk_search_queue_prod1_new)
        export BSCONFIG_IPORT=18995
        ;;
    messenger-search-queue-prod-yp)
        export SNAP_COUNT=1000000
        export ZSTD=false
        export CONC_GC_THREADS=3
        export PARALLEL_GCS=15
        ;;
esac

if test -x "$NANNY_SERVICE_ID.sh"
then
    source "$NANNY_SERVICE_ID.sh"
fi

export ZOO_CLIENT_PORT=${ZOO_CLIENT_PORT:-$BSCONFIG_IPORT}
export ZOO_HTTP_PORT=${ZOO_HTTP_PORT:-$((BSCONFIG_IPORT + 1))}
export ZOO_VOTE_PORT=${ZOO_VOTE_PORT:-$((BSCONFIG_IPORT + 2))}
export ZOO_DATA_PORT=${ZOO_DATA_PORT:-$((BSCONFIG_IPORT + 3))}
export GCLOGS_DIR=${GCLOGS_DIR:-/dev/shm/gclogs}
export DATA_DIR=${DATA_DIR:-/ssd/queue/data}
export CONFIG_TEMPLATE=${CONFIG_TEMPLATE:-queue.cfg.template}

