#!/bin/bash
set -exo pipefail

source config.sh

mkdir -p "$GCLOGS_DIR"
mkdir -p "$DATA_DIR"

sed "s#_VOTEPORT_#$ZOO_VOTE_PORT#g ; s#_ZOODATAPORT_#$ZOO_DATA_PORT#g ; s#_IPORT_PP_#$ZOO_HTTP_PORT#g ; s#_IPORT_#$ZOO_CLIENT_PORT#g ; s#_DATA_DIR_#$DATA_DIR#g" $CONFIG_TEMPLATE > queue.cfg

if hostname | grep -q "yp-c"; then
    echo "We are in yp. Set BSCONFIG_IHOST to a mtn name"
    BSCONFIG_IHOST=$(hostname | cut -d '.' -f 1-2)
fi

myId=$(sed -rn 's/^server\.([0-9]+)='$BSCONFIG_IHOST'.*?$/\1/p' queue.cfg)
echo $myId > "$DATA_DIR/myid"

