#!/bin/bash
set -exo pipefail

source config.sh

source classpath.sh

#export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | gawk '{print int($1*0.8)}')
#export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
GB=$((1024*1024*1024))
GB1_5=$((GB + (GB/2)))
MEMORY_GAP=${MEMORY_GAP:-$GB1_5}
XMX=$((MEMORY_LIMIT-MEMORY_GAP))

# https://www.oracle.com/technical-resources/articles/java/g1gc.html advises 5/8 in that case
# i don't get why, may be it apply only in nocontainer enviroment due to hyperthreading thing
PARALLEL_GCS=${PARALLEL_GCS:-$CPU_CORES}
CONC_GC_THREADS=${CONC_GC_THREADS:-1}
GC_ARGS="
-XX:+DisableExplicitGC
-Xlog:gc*:/dev/shm/gclogs/gc.log
-XX:+UnlockExperimentalVMOptions
-XX:+UseG1GC
-Xmx$XMX
-Xms$XMX
-Xmn512M
-XX:ParallelGCThreads=$PARALLEL_GCS
-XX:ConcGCThreads=$CONC_GC_THREADS
-XX:G1ConcRefinementThreads=1
-XX:MaxGCPauseMillis=50
-XX:G1MixedGCCountTarget=32
-XX:G1HeapWastePercent=20
-XX:G1AdaptiveIHOPNumInitialSamples=10
-XX:+PrintGCDetails
"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true -Dnetworkaddress.cache.ttl=10 -Dnetworkaddress.cache.negative.ttl=10"
ZOO_ARGS="
-Dru.yandex.lucene-storage.index-threads=2
-Dru.yandex.lucene-storage.merge-threads=3
-Dru.yandex.lucene-storage.use-compound-index=false
-Dzoolooser.traffic-compress.zstd=$ZSTD
-Dorg.apache.commons.logging.Log=org.apache.commons.logging.impl.SimpleLog
-Dorg.apache.commons.logging.simplelog.showdatetime=false
-Dorg.apache.commons.logging.simplelog.log.org.apache.http=OFF
-Dorg.apache.commons.logging.simplelog.log.org.apache.http.wire=OFF
-Dzookeeper.log.dir=/logs/
-Dzookeeper.root.logger=INFO,ROLLINGFILE
-Dzookeeper.forceSync=no -Djute.maxbuffer=64000000 -Dzookeeper.skipACL=yes
-Dzookeeper.snapCount=$SNAP_COUNT
"

ARGS=${ARGS:-queue.cfg}

exec $BSCONFIG_IDIR/jdk/bin/java \
    $JAVA_ARGS $GC_ARGS $NET_ARGS $ZOO_ARGS $ADDITIONAL_ARGS \
    -DBSCONFIG_IPORT=$BSCONFIG_IPORT \
    -Djava.library.path=. \
    -Djava.library.path=./zoolooser_service \
    -cp $CLASSPATH org.apache.zookeeper.server.quorum.QuorumPeerMain $ARGS

