#!/bin/bash
set -x
source config.sh
# watchdog works only with +e option, next line ensures that state
set +e

illseeks=$(grep -m1 -c -E -e "Illegal seek" -e "MergeException:" /logs/zookeeper.log)
if [ "$illseeks" != "0" ]; then
    >&2 echo "Move logs to another location before zoolooser is killed"               
    mv /logs/zookeeper.log /logs/zookeeper.illseek.log
    >&2 echo "zooloozer watchdog: Illegal seek's detected. Status script kill zoolooser"
    kill -9 $(cat ./pids/zoolooser)
fi
oom=$(fgrep -m1 -c "OutOfMemory" /logs/zookeeper.log)
if [ "$oom" != "0" ]; then
    >&2 echo "Move logs to another location before zoolooser is killed"               
    >&2 echo "zooloozer watchdog: OOM detected. restarted"
    mv /logs/zookeeper.log /logs/zookeeper.oom.log
    kill -9 $(cat ./pids/zoolooser)
fi
uptime=$(cat /proc/uptime | cut -d ' ' -f 1)
clkTck=$(getconf CLK_TCK)
proccessUptime=$(cat /proc/$(cat ./pids/zoolooser)/stat | awk -v uptime=$uptime -v clkTck=$clkTck '{print int(uptime-$22/clkTck)}')
if [ $proccessUptime -gt 900 ]; then
    success=0
    i=0;
    while [ $i -lt 10 ]; do
        i=$((i+1))
        nc -zw2 localhost $ZOO_CLIENT_PORT
        if [ $? -eq 0 ]; then
            success=1;
            break;
        else
            >&2 echo "Can't connect to main zoo port #"$i
            sleep 1
        fi
    done
    if [ $success -eq 0 ]; then
        >&2 echo "Killing zoolooser"
        kill -9 $(cat ./pids/zoolooser)
    fi
fi
