#!/bin/bash
set -exo pipefail

ARGS=$*
if [ "$ARGS" == "" ]; then
    ARGS="-server localhost:$SERVICE_PORT"
fi

source config.sh

source classpath.sh

export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
XMX=512M

GC_ARGS="
-XX:+DisableExplicitGC
-XX:+UseG1GC
-Xmx$XMX
-XX:ParallelGCThreads=1
-XX:ConcGCThreads=1
"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
ZOO_ARGS="
-Dorg.apache.commons.logging.Log=org.apache.commons.logging.impl.SimpleLog
-Dorg.apache.commons.logging.simplelog.showdatetime=false
-Dorg.apache.commons.logging.simplelog.log.org.apache.http=OFF
-Dorg.apache.commons.logging.simplelog.log.org.apache.http.wire=OFF
-Dzookeeper.log.dir=/logs/
-Dzookeeper.root.logger=INFO,ROLLINGFILE
-Dzookeeper.forceSync=no -Djute.maxbuffer=64000000 -Dzookeeper.skipACL=yes
"
exec ./jdk/bin/java \
    $JAVA_ARGS $GC_ARGS $NET_ARGS $ZOO_ARGS \
    -DBSCONFIG_IPORT=$BSCONFIG_IPORT \
    -Djava.library.path=. \
    -Djava.library.path=./zoolooser_service \
    -cp $CLASSPATH org.apache.zookeeper.ZooKeeperMain $ARGS
