#ifndef _ADNS_RESOLVER_SERVICE_H_
#define _ADNS_RESOLVER_SERVICE_H_

#include <boost/asio.hpp>
#include <boost/shared_ptr.hpp>
#include <yadns/service_base.h>
#include <yadns/resolver_options.h>

class adns_resolver_service
  : public service_base<adns_resolver_service>
{
  typedef boost::asio::posix::stream_descriptor stream_descriptor_t;
  typedef boost::shared_ptr<stream_descriptor_t> stream_descriptor_ptr_t;

  struct helper;

public:
  typedef boost::shared_ptr<helper> implementation_type;

private:
  struct basic_query;
  typedef boost::shared_ptr<basic_query> basic_query_ptr_t;

  template <class D, class I, class V>
  class basic_iterator;

  template <class Handler, class Iterator>
  struct query;

public:
  class iterator_a;
  class iterator_aaaa;
  class iterator_ptr;
  class iterator_txt;
  class iterator_mx;

  explicit adns_resolver_service(boost::asio::io_service& owner);

  void set_options(implementation_type& impl,
      const resolver_options& options);

  void construct(implementation_type& impl);

  void destroy(implementation_type& impl);

  void shutdown_service();

  void cancel(implementation_type& impl);

  template<typename Handler>
  void async_resolve_a(implementation_type& impl,
      const std::string& domain, Handler handler);

  template<typename Handler>
  void async_resolve_aaaa(implementation_type& impl,
      const std::string& domain, Handler handler);

  template<typename Handler>
  void async_resolve_ptr(implementation_type& impl,
      const std::string& ip, Handler handler);

  template<typename Handler>
  void async_resolve_txt(implementation_type& impl,
      const std::string& domain, Handler handler);

  template<typename Handler>
  void async_resolve_mx(implementation_type& impl,
      const std::string& domain, Handler handler);
};

#include <yadns/detail/adns_resolver_service.ipp>

#endif /* _ADNS_RESOLVER_SERVICE_H_ */
