#ifndef _BASIC_DNS_RESOLVER_H_
#define _BASIC_DNS_RESOLVER_H_

#include <yadns/resolver_options.h>

#include <boost/asio.hpp>

template <typename Service>
class basic_dns_resolver : public boost::asio::basic_io_object<Service>
{
public:
  explicit basic_dns_resolver(boost::asio::io_service& io_service)
    : boost::asio::basic_io_object<Service>(io_service)
  {
  }

  basic_dns_resolver(boost::asio::io_service& io_service, const resolver_options& options)
      : boost::asio::basic_io_object<Service>(io_service)
  {
      set_options(options);
  }

  typedef typename Service::iterator_a iterator_a;
  typedef typename Service::iterator_aaaa iterator_aaaa;
  typedef typename Service::iterator_ptr iterator_ptr;
  typedef typename Service::iterator_mx iterator_mx;
  typedef typename Service::iterator_txt iterator_txt;

  void set_options(const resolver_options& options)
  {
    this->get_service().set_options(
      this->get_implementation(), options);
  }

  template<typename Handler>
  void async_resolve_a(const std::string& q, Handler handler)
  {
    this->get_service().async_resolve_a(
      this->get_implementation(), q, handler);
  }

  template<typename Handler>
  void async_resolve_aaaa(const std::string& q, Handler handler)
  {
    this->get_service().async_resolve_aaaa(
      this->get_implementation(), q, handler);
  }

  template<typename Handler>
  void async_resolve_ptr(const std::string& q, Handler handler)
  {
    this->get_service().async_resolve_ptr(
      this->get_implementation(), q, handler);
  }

  template<typename Handler>
  void async_resolve_mx(const std::string& q, Handler handler)
  {
    this->get_service().async_resolve_mx(
      this->get_implementation(), q, handler);
  }

  template<typename Handler>
  void async_resolve_txt(const std::string& q, Handler handler)
  {
    this->get_service().async_resolve_txt(
      this->get_implementation(), q, handler);
  }

  void cancel()
  {
    this->get_service().cancel(this->get_implementation());
  }
};

#endif /* _BASIC_DNS_RESOLVER_H_ */
