# encoding: utf-8
from __future__ import unicode_literals


class TSKV(object):
    def fix_string(self, string):
        if isinstance(string, str):
            string = string.decode('utf-8')
        return string

    def to_dict(self, string):
        d = dict()
        # valid tskv looks like:
        # 'tskv      key=value       key1=value1'
        string = string.strip()
        if not string:
            return None
        string = self.fix_string(string)
        if string.startswith('tskv'):
            # chop off leading 'tskv' substring
            for field in string.split('\t')[1:]:
                kv = field.split('=', 1)
                if len(kv) > 1:
                    d[kv[0]] = kv[1]
                else:
                    # Emtpy field -- probably a runaway tab. Skip it.
                    continue
        else:
            return None
        return d


class AM_TSKV(TSKV):
    """
    Парсер записей логов АппМетрики
    """
    filters = (
        "\tEventType=EVENT_PUSH_TOKEN",
    )

    def to_dict(self, string):
        string = self.fix_string(string)
        for f in self.filters:
            if f in string:
                return super(AM_TSKV, self).to_dict(string)
        return None
