# encoding: utf-8
from __future__ import unicode_literals

import logging
from logbroker_processors.processors import Processor

from .pusher import EventPushTokensPusher, AppMetricsPushError


class AppMetricsPTProcessor(Processor):
    """ Консьюмер для логов АппМетрики """
    _required_fields = frozenset((
        'UUID',
        'DeviceID',
        'EventType',
        'EventValue',
        'AppPlatform',
        'AppID',
        'APIKey',
        'EventTimestamp',
    ))
    _other_fields = frozenset((
        'AccountID',
    ))
    _sandbox_accounts = frozenset((
        '103164068',
        '15020368',
        '18021017',
        '26691975',
        '316134018',
        '362849697',
        '38117510',
        '414697401',
        '420771248',
        '429725276',
        '441067589',
        '46871412',
        '554991636',
        '554993439',
        '86488496',
        '89241080',
    ))

    def __init__(self, **args):
        super(AppMetricsPTProcessor, self).__init__()
        self._fields = self._required_fields | self._other_fields
        self._pusher = EventPushTokensPusher(**args.get('pusher', {}))
        self._sandbox_pusher = EventPushTokensPusher(
            **args.get('sandbox_pusher', {}))

    def process(self, header, data):
        record = {k: v for k, v in data.iteritems() if k in self._fields}
        if self._validate(record):
            try:
                if self._is_sandbox_account(record):
                    self._sandbox_pusher.push(record)
                else:
                    self._pusher.push(record)
            except AppMetricsPushError as exc:
                logging.debug('Got error from pusher: %s', exc)
                return False
            return True
        return False

    def flush(self, force=False):
        pass

    def _validate(self, record):
        for f in self._required_fields:
            if f not in record:
                return False
        return True

    def _is_sandbox_account(self, record):
        return 'AccountID' in record \
                and record['AccountID'] in self._sandbox_accounts
