# -*- coding: utf-8 -*-
from .base import BaseGraphiteProcessor
import logbroker_client_common.utils as utils

import logging
log = logging.getLogger(__name__)


class MDBGraphiteProcessor(BaseGraphiteProcessor):
    """
    Каждая функция это экстрактор. Ей приходят данные, а она должна обновить занчени(е,я) метрик(и).
    Для обновления вызываются методы специального класса, инстанс которого доступен через self.metrics.

    self.metric.(set()|increment()) - функции модификации метрик
    self.hostname - имя машины, где работает этот код (консумера, т.е.)
    meta.server - имя машины, откуда пришла метрика
    meta.path - имя файла на хосте отправителе
    meta.ident - ident в пушклиенте

    data это TSKV, сконвертированный в словарь:

    tskv    module=settings operation=get   unixtime=<time> mdb=mdb100        bla=foo

    data = {
        'module': 'settings',
        'operation': 'get',
        'unixtime': '<time>' # как строка, никакой магии
        ...
        }

    Экстракторы могут иметь следующие вызовы:
    1. metric.increment('metric_name.in.graphite_form', <unix epoch timestamp>, <step>)
    Инкрементить метрику. Если еще такой не видели, создать. Если есть step, то место var++ делаем var += step.
    2. metric.set('metric_name.in.graphite_form', <unix epoch timestamp>, newvalue)
    Выставить значение для текущей минуты в newvalue.

    Вызовы сами округляют все timestamp`ы до ближайшей минуты (в сторону "прошлого").

    Подробнее см. base.BaseGraphiteProcessor.
    """
    def get_operations(self, data, meta):
        try:
            module = data['module'].strip().replace('.', '_')
            action = data['operation'].strip().replace('.', '_')
            mdb = data['mdb'].strip().replace('.', '_')
            ts = data['unixtime'].strip()
            # Вот тут обновляется метрика. return не нужен.
            # Выглядеть будет так (на влете в графит): 'mdb.userjournal.mdb320a.yserver_imap.authorization 34 1485862665'
            self.metrics.increment('mail.mdb.userjournal.{host}.{db}.{mod}.{act}'.format(host=self.hostname, db=mdb, mod=module, act=action), ts)
        except KeyError:
            # Данные кривые: нужного ключа не было. Игнорируем строку.
            pass
    # def get_blah(self, data):
    #     try:
    #         foo = data['bar'].strip().replace('.', '_')
    #         ...
    #         self.metrics.increment('prefix.another.service.host'
    #     except KeyError:
    #         pass
