from .base import BaseProcessor
import time
import logging

log = logging.getLogger(__name__)


class Forward(BaseProcessor):

    def forward_sessionid_ts(self, header, data):
        assert isinstance(data, dict)

        # Construct key from timestamp.
        try:
            ts = time.strptime(data['timestamp'], '%Y-%m-%d %H:%M:%S')
            # utils.reverse_ts will take care of None stuff.
            ms = data.get('time_ms') or None
            session_id = self.md5(data['session_id'])
        except KeyError:
            raise ValueError("unable to get queue id or timestamp from string")

        key = "{ses_id}_{r_ts:020d}".format(ses_id=session_id, r_ts=self.reverse_ts(ts, msecs=ms))
        processed_data = self.filter_dict(data, ['tskv_format', 'postfix_daemon', 'localhost', 'postfix_daemon_pid'])

        return {
            'data': processed_data,
            'key': key,
            }

    def forward_messageid_sessionid(self, header, data):
        assert isinstance(data, dict)

        # Construct key
        try:
            message_id = self.md5(data['message_id'])
            session_id = self.md5(data['session_id'])
        except KeyError:
            raise ValueError("unable to get message or queue id from string")

        key = "{mes_id}_{ses_id}".format(mes_id=message_id, ses_id=session_id)

        processed_data = self.filter_dict(data, ['tskv_format', 'postfix_daemon', 'localhost', 'postfix_daemon_pid'])

        return {
            'data': processed_data,
            'key': key,
        }

    def forward_from_sessionid(self, header, data):
        assert isinstance(data, dict)

        try:
            session_id = self.md5(data['session_id'])
            ts = time.strptime(data['timestamp'], '%Y-%m-%d %H:%M:%S')
            # utils.reverse_ts will take care of None stuff.
            ms = data.get('time_ms') or None
            mail_from = data['from'].strip()
            if not mail_from:
                raise KeyError
        except KeyError:
            raise ValueError("unable to get from or queue id fields from string")

        key = "{ml_from}_{r_ts:020d}_{ses_id}".format(ml_from=mail_from, r_ts=self.reverse_ts(ts, msecs=ms), ses_id=session_id)

        # The data.
        processed_data = {'timestamp': data['timestamp'], 'session_id': data['session_id']}

        return {
            'data': processed_data,
            'key': key,
        }
