# encoding: utf-8
from __future__ import unicode_literals
import requests
import logging


class BaseAPIError(Exception):
    pass


class APIConnectionError(BaseAPIError):
    pass


class ResponseError(BaseAPIError):
    pass


class BaseAPI(object):
    def __init__(self, host, port, path):
        self.url = 'http://{host}:{port}/{path}'.format(host=host, port=port, path=path)
        self._http_client = None

    @property
    def http_client(self):
        if not self._http_client:
            self._http_client = requests.Session()

        return self._http_client

    def _make_request(self, params, json=True):
        try:
            response = self.http_client.get(self.url, params=params)
            if response.status_code != 200:
                raise ResponseError('request failed with params %s, status code %s' % (params,
                                    response.status_code))

            logging.debug('%s: succeeded request %s with params "%s"', self.__class__.__name__, self.url, params)

            if json:
                return response.json()

        except requests.RequestException:
            self._http_client = None
            raise APIConnectionError('request failed with params %s' % params)
