# encoding: utf-8
from __future__ import unicode_literals

import json

from .utils import retry_on
from .api import APIConnectionError, BaseAPI


class SoAPI(BaseAPI):
    @retry_on(APIConnectionError)
    def report(self, reports, reports_type, source):
        params = {'source': source, 'type': reports_type, 'json': json.dumps(reports)}
        self._make_request(params, json=False)
