# encoding: utf-8
from __future__ import unicode_literals
from functools import wraps
import logging


def retry_on(exc=(Exception,), retries=2):
    def decorator(func):
        @wraps(func)
        def wrapper(self, *args, **kwargs):
            for retry in xrange(1, retries + 1):
                try:
                    return func(self, *args, **kwargs)
                except exc:
                    if retry == retries:
                        logging.error('Method "%s.%s" failed after %s retries' %
                                      (self.__class__.__name__, func.__name__, retry))
                        raise
        return wrapper
    return decorator
