# encoding: utf-8
from __future__ import unicode_literals

import requests

from logging import getLogger

logger = getLogger(__name__)


def sessions_producer(tvm):
    import cachetools

    cache = cachetools.TTLCache(128, 1800)
    ticket_getter = tvm.ticket_getter()

    @cachetools.cached(cache=cache)
    def get_ticket_headers(dst, scopes):
        return ticket_getter.get_service_ticket_headers(dst, scopes=scopes)[str(dst)]

    class TvmSession(requests.Session):
        def __init__(self, tvm_dst, scopes=None, *args, **kwargs):
            super(TvmSession, self).__init__(*args, **kwargs)
            if not isinstance(self.verify, basestring):
                self.verify = '/etc/ssl/certs/ca-certificates.crt'
            self._dst = tvm_dst
            self._scopes = scopes

        def request(self, *args, **kwargs):
            headers = kwargs.pop('headers', None)
            tvm_headers = get_ticket_headers(self._dst, self._scopes)
            if headers:
                for k, v in tvm_headers.items():
                    headers[k] = v
            else:
                headers = tvm_headers

            return super(TvmSession, self).request(*args, headers=headers, **kwargs)

    return TvmSession
