from collections import namedtuple
import re

MimePart = namedtuple('MimePart', [
    'hid',
    'content_type',
    'content_subtype',
    'boundary',
    'name',
    'charset',
    'encoding',
    'content_disposition',
    'filename',
    'cid',

    'offset_begin',
    'offset_end'
])


def get_st_id(cur, uid, mid):
    sql_stid = """SELECT st_id FROM mail.messages
                   WHERE uid=%s AND mid=%s"""
    cur.execute(sql_stid, (uid, mid))
    row = cur.fetchone()
    if row is None:
        return None
    return row[0]


def mdb_put(cur, params):
    sql_mime = """INSERT INTO mail.windat_messages
                  VALUES (%(uid)s, %(mid)s, %(st_id)s, %(hid)s,
                               %(windat)s::mail.mime_part) ON CONFLICT DO NOTHING"""
    cur.execute(sql_mime, params)


def get_mime(cur, uid, mid):
    sql_mime = """SELECT mime FROM mail.messages
                  WHERE  uid = %s
                    AND  mid = %s"""
    cur.execute(sql_mime, (uid, mid))
    parts = cur.fetchone()
    if parts is None:
        return []
    parts = re.findall('\([^)]*\)', parts[0])
    return [parse_part(part) for part in parts]


def parse_part(part):
    fields = part[1:-1].split(',')
    return MimePart(*fields)


def get_offsets(cur, uid, mid, hid):
    mime_parts = get_mime(cur, uid, mid)
    for mime_part in mime_parts:
        if mime_part.hid == hid:
            return mime_part.offset_begin, mime_part.offset_end
    return None, None
