from logbroker_processors.utils.service_base_client import ServiceBaseClient
from .windat_logger import get_logger

log = get_logger(__name__)


class MulcaClient(ServiceBaseClient):
    def _process_response(self, r):
        return r.text

    def mulca_put(self, eml):
        return self.post(url=self.endpoint_url('gate/put/windat'),
                         params={'raw': '', 'service': 'windat', 'ns': 'mail', 'elliptics': '1'},
                         data=eml)

    def get_attach(self, st_id, offset_begin, offset_end):
        return self.get(url=self.endpoint_url('gate/get/%s' % st_id),
                        params={'service': 'windat'},
                        headers={'Range': 'bytes=%s-%s' % (offset_begin, int(offset_end) - 1)})
