# encoding: utf-8
# TestCase mail statistics
header = {'path': '/var/log/mops/user_journal.tskv',
          'ident': 'userjournal',
          'offset': '3',
          'partition': '0',
          'seqno': '9921',
          'server': 'logship-dev01e.cmail.yandex.net',
          'sourceid': 'base64:eL5wm2zzRya7j7ZHsKS2Zg',
          'topic': 'rt3.sas--userjournal--raw',
          }

data_abuse = """
tskv\tuid=00000000000277570702\tclientType=mob-app-unknown\tmdb=pg\tip=94.242.161.227\ttableName=users_history\tmodule=spam_report\tuserAgent=ru.yandex.mail/3.12.29527 (HUAWEI HUAWEI TAG-L21; Android 5.1)\toperation=abuse\tsuid=823531216\tstate=unread_trash;160722211701789292\tunixtime=1481057984\trequestId=9d6c7d279a176635a6debb8677a2a474\taffected=1\tsubkey= source_uri=prt://userjournal@web28h.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=1ed630fda8fe83fc2f674ac4617e4f06\tdate=1481057984029\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:44\ttarget=message\tabuseType=unread_trash\tmids=160722211701789292
tskv\tuid=00000000000207775445\tclientType=TOUCH\tmdb=pg\tip=91.126.191.168\ttableName=users_history\tmodule=spam_report\tuserAgent=Mozilla/5.0 (iPad; CPU OS 6_1_3 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Version/6.0 Mobile/10B329 Safari/8536.25\toperation=abuse\tsuid=646896870\tstate=unread_trash;160159261748367365\tunixtime=1481057984\trequestId=b2f10e252b7f7cce8ff1475caf79bc51\taffected=1\tsubkey= source_uri=prt://userjournal@web34m.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=iface-1481057582729-02474369\tdate=1481057984014\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:44\ttarget=message\tabuseType=unread_trash\tyandexuidCookie=9038830751363106100\tmids=160159261748367365
tskv\tuid=00001130000014467722\tclientType=DARIA\tmdb=pg\tip=93.85.52.77\ttableName=users_history\tmodule=spam_report\tuserAgent=Mozilla/5.0 (Windows NT 5.1; rv:50.0) Gecko/20100101 Firefox/50.0\toperation=abuse\tsuid=1130000031670983\tstate=spam;160722211701789693\tunixtime=1481057985\ttest-buckets=25468,0,90;32334,0,80\trequestId=dfd02c00dece519032ab20facc3c3849\taffected=1\tsubkey=\tsource_uri=prt://userjournal@web11g.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=neo2-1481057963605-22789839\tenabled-test-buckets=25468,0,90;32334,0,80\tdate=1481057985409\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:45\ttarget=message\tabuseType=spam\tyandexuidCookie=4917435461475167111\tmids=160722211701789693
tskv\tuid=00001130000021496862\tclientType=mob-app-unknown\tmdb=pg\tip=78.167.197.90\ttableName=users_history\tmodule=spam_report\tuserAgent=ru.yandex.mail/3.12.29527 (samsung SM-J200F; Android 5.1.1)\toperation=abuse\tsuid=1130000038700238\tstate=spam;160722211701785208,160722211701785210,160722211701785209,160722211701785211,160722211701785212\tunixtime=1481057987\trequestId=6bfd5770e163180fe7324f7cb24564e9\taffected=5\tsubkey= source_uri=prt://userjournal@web22h.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=7aafed5dfebc2340cb7b7136ab3dcf96\tdate=1481057987323\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:47\ttarget=message\tabuseType=spam\tmids=160722211701785208,160722211701785210,160722211701785209,160722211701785211,160722211701785212
tskv\tuid=00000000000042357766\tclientType=LIZA\tmdb=pg\tip=109.252.86.152\ttableName=users_history\tmodule=spam_report\tuserAgent=Mozilla/5.0\t(Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0\toperation=abuse\tclientVersion=12.6.503\tsuid=112330908\tstate=nonspam;160722211701788809\tunixtime=1481057989\trequestId=2bea650780ac5e080eabe991ffc57067\ttest-buckets=28235,0,89;33824,0,28;25467,0,11;34679,0,76;31190,0,12;32334,0,76\tsubkey=\taffected=1\tsource_uri=prt://userjournal@web32j.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=u2709-1481057868302-38640627\tenabled-test-buckets=28235,0,89;33824,0,28;25467,0,11;34679,0,76;31190,0,12\tdate=1481057989088\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:49\ttarget=message\tabuseType=nonspam\tyandexuidCookie=2789149791470563153\tmids=160722211701788809
tskv\tuid=00001130000021699468\tmdb=pg\tip=206.190.158.75\ttableName=users_history\tmodule=spam_report\tuserAgent=Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0\toperation=abuse\tsuid=1130000038902783\tstate=nonspam;160722211701784795\tunixtime=1481057999\trequestId=9055693474457966aff4bfd18b14d2ee\taffected=1\tsubkey= source_uri=prt://userjournal@web38j.yandex.ru/var/log/mops/user_journal.tskv\tdate=1481057999990\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:59\ttarget=message\tabuseType=nonspam\tyandexuidCookie=4653967811469797472\tmids=160722211701784795
tskv\tuid=00000000000042357766\tclientType=LIZA\tmdb=pg\tip=109.252.86.152\ttableName=users_history\tmodule=spam_report\tuserAgent=Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0\toperation=abuse\tclientVersion=12.6.503\tsuid=112330908\tstate=nonspam;160722211701788809\tunixtime=1481057989\trequestId=2bea650780ac5e080eabe991ffc57067\ttest-buckets=28235,0,89;33824,0,28;25467,0,11;34679,0,76;31190,0,12;32334,0,76\tsubkey=\taffected=1\tsource_uri=prt://userjournal@web32j.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=u2709-1481057868302-38640627\tenabled-test-buckets=28235,0,89;33824,0,28;25467,0,11;34679,0,76;31190,0,12\tdate=1481057989088\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:49\ttarget=message\tabuseType=unsubscribe\tyandexuidCookie=2789149791470563153\tmids=160722211701788809
tskv\tuid=00001130000021699468\tmdb=pg\tip=206.190.158.75\ttableName=users_history\tmodule=spam_report\tuserAgent=Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0\toperation=abuse\tsuid=1130000038902783\tstate=nonspam;160722211701784795\tunixtime=1481057999\trequestId=9055693474457966aff4bfd18b14d2ee\taffected=1\tsubkey= source_uri=prt://userjournal@web38j.yandex.ru/var/log/mops/user_journal.tskv\tdate=1481057999990\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:59\ttarget=message\tabuseType=unsubscribe\tyandexuidCookie=4653967811469797472\tmids=160722211701784795
"""
expected_abuse = (
    'tskv\tdate=2016-12-05\toperation=abuse_unread_trash\tsource=userjournal\town_mail=1\tuid=277570702\tmid=160722211701789292\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=abuse_unread_trash\tsource=userjournal\town_mail=1\tuid=207775445\tmid=160159261748367365\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=abuse_spam\tsource=userjournal\town_mail=1\tuid=1130000014467722\tmid=160722211701789693\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=abuse_spam\tsource=userjournal\town_mail=1\tuid=1130000021496862\tmid=160722211701785208\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=abuse_spam\tsource=userjournal\town_mail=1\tuid=1130000021496862\tmid=160722211701785210\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=abuse_spam\tsource=userjournal\town_mail=1\tuid=1130000021496862\tmid=160722211701785209\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=abuse_spam\tsource=userjournal\town_mail=1\tuid=1130000021496862\tmid=160722211701785211\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=abuse_spam\tsource=userjournal\town_mail=1\tuid=1130000021496862\tmid=160722211701785212\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=abuse_nonspam\tsource=userjournal\town_mail=1\tuid=42357766\tmid=160722211701788809\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=abuse_nonspam\tsource=userjournal\town_mail=1\tuid=1130000021699468\tmid=160722211701784795\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=abuse_unsubscribe\tsource=userjournal\town_mail=1\tuid=42357766\tmid=160722211701788809\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=abuse_unsubscribe\tsource=userjournal\town_mail=1\tuid=1130000021699468\tmid=160722211701784795\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
)

data_click = """
tskv\torigin=message\tclientVer=12.6.503\tuid=1130000003556897\tunixtime=1481057976\ttableName=users_history\tmodule=jsintegration\tuserAgent=Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36\tuserIp=2a02:2168:1546:7600:a01b:7f32:bf4c:6b7c\ttimezone=+0300\toperation=linkClick\tuuid=iface-1481057976349-40621409\tmid=160722211701794236\tstate=160722211701794236\tyandexuid=5413571321477588844\tsubkey= status=ok\ttimestamp=2016-12-06 23:59:36\tsource_uri=prt://userjournal@web7h.yandex.ru/var/log/wmi/jsintegration.log\tdate=1481057976360\ttskv_format=mail-user-journal-log\trequestId=24823e5d5a4aede4eca8f37111f86bfa\tvdirectResult=1\tiso_eventtime=2016-12-06 23:59:36\ttarget=message\turl=http://energosnab.pro/arenda_dizelnogo_generatora.html\tclient=LIZA\torgId=users_history
tskv\torigin=message\tclientVer=12.6.503\tuid=355999914\tunixtime=1481057976\ttableName=users_history\tmodule=jsintegration\tuserAgent=Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 YaBrowser/16.10.1.1114 Yowser/2.5 Safari/537.36\tuserIp=178.150.5.94\ttimezone=+0300\toperation=linkClick\tuuid=iface-1481057976253-32211651\tmid=160722211701787046\tstate=160722211701787046\tyandexuid=7207163331454857699\tsubkey= status=ok\ttimestamp=2016-12-06 23:59:36\tsource_uri=prt://userjournal@web29o.yandex.ru/var/log/wmi/jsintegration.log\tdate=1481057976281\ttskv_format=mail-user-journal-log\trequestId=77185db5aa14e495bd27e793c82ee445\tvdirectResult=1\tiso_eventtime=2016-12-06 23:59:36\ttarget=message\turl=https://star.flint.tm/confirm/1d8360be7210a3cd71e14fc349f0f644?setcountry=1\tclient=LIZA\torgId=users_history
"""
expected_click = (
    'tskv\tdate=2016-12-05\toperation=link_click\tsource=userjournal\town_mail=1\tuid=1130000003556897\tmid=160722211701794236\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=link_click\tsource=userjournal\town_mail=1\tuid=355999914\tmid=160722211701787046\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
)

data_delete = """
tskv\taffected=1\tuid=00000000000052760493\tsuid=143905324\tmdb=xdb19\tip=127.0.0.1\tsource_uri=prt://userjournal@mxback8h.mail.yandex.net/var/log/user_journal.tskv\tconnectionId=7gKc2173\ttableName=users_history\tmodule=fastsrv\t\tstate=160722211701810908\tsubkey=\ttskv_format=mail-user-journal-tskv-log\tunixtime=1481057984\tdate=1481057984365\tiso_eventtime=2016-12-06 23:59:44\toperation=delete\tmids=160722211701810908\ttarget=message
tskv\taffected=4\tuid=00000000000035486333\tsuid=90341648\tmdb=pg\tip=::ffff:95.183.89.109\tsource_uri=prt://userjournal@imap1h.mail.yandex.net/var/log/ypop/user_journal.tskv\ttableName=users_history\tmodule=yserver_pop\tstate=160722211701794265,160722211701794266,160722211701794263,160722211701794264\tsubkey=\ttskv_format=mail-user-journal-log\tunixtime=1481057985\tdate=1481057985307\tiso_eventtime=2016-12-06 23:59:45\toperation=delete\tmids=160722211701794265,160722211701794266,160722211701794263,160722211701794264\ttarget=message
"""
expected_delete = (
    'tskv\tdate=2016-12-05\toperation=delete\tsource=userjournal\town_mail=1\tuid=52760493\tmid=160722211701810908\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=delete\tsource=userjournal\town_mail=1\tuid=35486333\tmid=160722211701794265\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=delete\tsource=userjournal\town_mail=1\tuid=35486333\tmid=160722211701794266\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=delete\tsource=userjournal\town_mail=1\tuid=35486333\tmid=160722211701794263\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=delete\tsource=userjournal\town_mail=1\tuid=35486333\tmid=160722211701794264\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
)

data_mark = """
tskv\tuid=00000000000094785217\tclientType=LIZA\tmdb=xdb303\tip=176.112.71.207\ttableName=users_history\tmodule=mailbox_oper\tuserAgent=Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36 OPR/41.0.2353.69\toperation=mark\tclientVersion=12.6.503\tsuid=263186235\tmsgStatus=read\tstate=read;160722211701788522,160722211701788523\tunixtime=1481057994\trequestId=1eb5c84618468d6e37385c28993e0ca6\ttest-buckets=25468,0,64;34680,0,30;32334,0,37\tsubkey=\taffected=2\tsource_uri=prt://userjournal@web4o.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=u2709-1481057986567-73888593\tenabled-test-buckets=25468,0,64;34680,0,30\tdate=1481057994029\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:54\ttarget=message\tyandexuidCookie=932962151478986294\tmids=160722211701788522,160722211701788523
tskv\tuid=00000000000441477249\tclientType=LIZA\tmdb=xdb51\tip=83.220.237.43\ttableName=users_history\tmodule=mailbox_oper\tuserAgent=Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36\toperation=mark\tclientVersion=12.6.503\tsuid=967750864\tmsgStatus=read\tstate=read;160722211701784577\tunixtime=1481057998\trequestId=61dc82d1223965b00bdd75c7daa8780f\ttest-buckets=32962,0,92;25467,0,95;34679,0,24;32334,0,67\tsubkey=\taffected=1\tsource_uri=prt://userjournal@web4o.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=u2709-1481057962589-39877382\tenabled-test-buckets=32962,0,92;25467,0,95;34679,0,24\tdate=1481057998426\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:58\ttarget=message\tyandexuidCookie=2156707541418231754\tmids=160722211701784577
tskv\tuid=00001130000018301269\tclientType=mob-app-unknown\tmdb=xdb03\tip=94.25.188.180\ttableName=users_history\tmodule=mailbox_oper\tuserAgent=ru.yandex.mail/340.270 (iPhone9,3; iPhone OS 10.1.1)\toperation=mark\tsuid=1130000035505518\tmsgStatus=unread\tstate=unread;160722211701863975\tunixtime=1481057999\trequestId=204ecec9086354a1eae96c35c4a65203\taffected=1\tsubkey=\tsource_uri=prt://userjournal@web11g.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=6985ce4bafc5457122a8979f5ba202e6\tdate=1481057999477\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:59\ttarget=message\tmids=160722211701863975
tskv\tuid=00000000000000182792\tclientType=TOUCH\tmdb=xdb04\tip=93.120.244.170\ttableName=users_history\tmodule=mailbox_oper\tuserAgent=Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-A500F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36\toperation=mark\tsuid=397112\tmsgStatus=unread\tstate=unread;160722211701798775\tunixtime=1481057998\trequestId=3c72a1ee761fb307063bbddeb2607623\taffected=1\tsubkey=\tsource_uri=prt://userjournal@web8m.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=iface-1481056693556-36059744\tdate=1481057998755\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:58\ttarget=message\tyandexuidCookie=777483981463488820\tmids=160722211701798775
tskv\taffected=1\tuid=00000000000013133060\tsuid=30491424\tmdb=xdb05\tip=5.228.250.218\tsource_uri=prt://userjournal@web18o.yandex.ru/var/log/mops/user_journal.tskv\ttableName=users_history\tmodule=mailbox_oper\tmids=160722211701785891\tstate=forwarded;160722211701785891\tsubkey=\tyandexuidCookie=4505104921415458086\tunixtime=1481057996\tdate=1481057996804\ttskv_format=mail-user-journal-tskv-log\toperation=mark\ttarget=message\tiso_eventtime=2016-12-06 23:59:56\trequestId=94bf823c139dbfb0a7dd7a18da203697
tskv\tuid=00000000000029087069\tmdb=xdb04\tip=37.112.240.115\ttableName=users_history\tmodule=mailbox_oper\toperation=mark\tsuid=70894991\tmsgStatus=forwarded\tstate=forwarded;160722211701787438\tunixtime=1481057993\trequestId=283a385f26fcc9eac57d636cb477ca4d\taffected=1\tsubkey=\tsource_uri=prt://userjournal@web19o.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=u2709-1481057638887-88786414\tdate=1481057993938\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:53\ttarget=message\tyandexuidCookie=5783196731445801554\tmids=160722211701787438
tskv\tuid=00000000000111656680\tmdb=xdb35\tip=95.106.33.32\ttableName=users_history\tmodule=mailbox_oper\toperation=mark\tsuid=311572596\tmsgStatus=replied\tstate=replied;160722211701799401\tunixtime=1481057994\trequestId=a026e8594a9f5b81fa355f8fb62052ed\taffected=1\tsubkey=\tsource_uri=prt://userjournal@web3m.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=u2709-1481057806235-79045456\tdate=1481057994379\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:54\ttarget=message\tyandexuidCookie=2163065411439287314\tmids=160722211701799401
tskv\tuid=00000000000000271118\tmdb=xdb13\tip=178.71.12.175\ttableName=users_history\tmodule=mailbox_oper\toperation=mark\tsuid=573688\tmsgStatus=replied\tstate=replied;160722211701788840\tunixtime=1481057994\trequestId=ab530dde729c7d7936d0f88ac361537a\taffected=1\tsubkey=\tsource_uri=prt://userjournal@web5g.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=u2709-1481057917852-46004440\tdate=1481057994954\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:54\ttarget=message\tyandexuidCookie=6553039201405812209\tmids=160722211701788840
"""
expected_mark = (
    'tskv\tdate=2016-12-05\toperation=mark_read\tsource=userjournal\town_mail=1\tuid=94785217\tmid=160722211701788522\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=mark_read\tsource=userjournal\town_mail=1\tuid=94785217\tmid=160722211701788523\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=mark_read\tsource=userjournal\town_mail=1\tuid=441477249\tmid=160722211701784577\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=mark_unread\tsource=userjournal\town_mail=1\tuid=1130000018301269\tmid=160722211701863975\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=mark_unread\tsource=userjournal\town_mail=1\tuid=182792\tmid=160722211701798775\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=mark_forwarded\tsource=userjournal\town_mail=1\tuid=29087069\tmid=160722211701787438\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=mark_replied\tsource=userjournal\town_mail=1\tuid=111656680\tmid=160722211701799401\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=mark_replied\tsource=userjournal\town_mail=1\tuid=271118\tmid=160722211701788840\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
)

data_move = """
tskv\tuid=00000000000168187814\tclientType=mob-app-unknown\tmdb=xdb36\tip=195.142.178.47\ttableName=users_history\tmodule=mailbox_oper\tuserAgent=ru.yandex.mail/3.12.29527 (General Mobile GM 5 Plus; Android 7.0)\toperation=move\tsuid=521399754\tstate=fid=3;mids=160722211701798052\tunixtime=1481057993\trequestId=3b93cf9f958842b8d4fda1e767f10bfb\taffected=1\tsubkey=\tsource_uri=prt://userjournal@web3o.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=2b4aaf10241fc69b43793ca0f34564c5\tdestFid=3\tdate=1481057993806\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:53\ttarget=message\tmids=160722211701798052
tskv\tuid=00000000000106153795\tclientType=LIZA\tmdb=xdb46\tip=213.87.146.215\ttableName=users_history\tmodule=mailbox_oper\tuserAgent=Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36\toperation=move\tclientVersion=12.6.503\tsuid=295787971\tstate=fid=3;mids=160440736725074746,160440736725074751,160722211701785432,160440736725074747,160440736725074753,160440736725074759,160440736725074749,160440736725074748,160440736725074752,160440736725074750\tunixtime=1481057993\trequestId=1b3fd7db2237669f0cf06f9e52b6d620\ttest-buckets=32952,0,54;35270,0,67;31541,0,67;21981,0,38;34680,0,9;32334,0,37\tsubkey=\taffected=10\tsource_uri=prt://userjournal@web18o.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=u2709-1481057378628-17868713\tenabled-test-buckets=32952,0,54;35270,0,67;31541,0,67;21981,0,38;34680,0,9\tdestFid=3\tdate=1481057993983\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:53\ttarget=message\tyandexuidCookie=8288291341457539298\tmids=160440736725074746,160440736725074751,160722211701785432,160440736725074747,160440736725074753,160440736725074759,160440736725074749,160440736725074748,160440736725074752,160440736725074750
"""
expected_move = (
    'tskv\tdate=2016-12-05\toperation=move\tsource=userjournal\town_mail=1\tuid=168187814\tmid=160722211701798052\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\tfid=3',
    'tskv\tdate=2016-12-05\toperation=move\tsource=userjournal\town_mail=1\tuid=106153795\tmid=160440736725074746\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\tfid=3',
    'tskv\tdate=2016-12-05\toperation=move\tsource=userjournal\town_mail=1\tuid=106153795\tmid=160440736725074751\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\tfid=3',
    'tskv\tdate=2016-12-05\toperation=move\tsource=userjournal\town_mail=1\tuid=106153795\tmid=160722211701785432\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\tfid=3',
    'tskv\tdate=2016-12-05\toperation=move\tsource=userjournal\town_mail=1\tuid=106153795\tmid=160440736725074747\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\tfid=3',
    'tskv\tdate=2016-12-05\toperation=move\tsource=userjournal\town_mail=1\tuid=106153795\tmid=160440736725074753\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\tfid=3',
    'tskv\tdate=2016-12-05\toperation=move\tsource=userjournal\town_mail=1\tuid=106153795\tmid=160440736725074759\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\tfid=3',
    'tskv\tdate=2016-12-05\toperation=move\tsource=userjournal\town_mail=1\tuid=106153795\tmid=160440736725074749\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\tfid=3',
    'tskv\tdate=2016-12-05\toperation=move\tsource=userjournal\town_mail=1\tuid=106153795\tmid=160440736725074748\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\tfid=3',
    'tskv\tdate=2016-12-05\toperation=move\tsource=userjournal\town_mail=1\tuid=106153795\tmid=160440736725074752\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\tfid=3',
    'tskv\tdate=2016-12-05\toperation=move\tsource=userjournal\town_mail=1\tuid=106153795\tmid=160440736725074750\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\tfid=3',
)

data_receive = """
tskv\ttskv_format=mail-user-journal-tskv-log\ttableName=users_history\tuid=00001130000022236626\tmodule=fastsrv\tip=127.0.0.1\tsuid=1130000039439900\tconnectionId=OZtdRfqP\ttarget=message\toperation=receive\tdate=1486588013270\tunixtime=1486588013\thidden=1\tmdb=pg\tstate=X-Mailer="Yamail [ http://yandex.ru ] 5.0"\taffected=1\tfid=6\tmid=161285161655205895\ttid=161285161655205895\tstid=105776.1130000039439900.2808901204109379126815876182816\tftype=2\temailFrom=anna@mozgova.ru\tlabelSymbols=draft_label,seen_label\tsubject=\\u0432\\u0438\\u0440\\u0443\\u0441\\u044b \\u043d\\u0430 \\u0441\\u0430\\u0439\\u0442\\u0430\\u0445\tmsgId=<695031486588012@web12h.yandex.ru>\temailTo=test@yandex.ru\temailCc=test2@yandex.ru\temailBcc=test3@yandex.ru\t
tskv\ttskv_format=mail-user-journal-tskv-log\ttableName=users_history\tuid=00000000000113430969\tmodule=fastsrv\tip=2a02:6b8:0:f05::94\tsuid=316514729\tconnectionId=GD3k7vvgSI-6sW0W9aL\ttarget=message\toperation=receive\tdate=1486588015251\tunixtime=1486588015\thidden=0\tmdb=pg\tstate=List-Id="<realty.sub.used>",X-Mailer="YandexSender/0.1"\taffected=1\tfid=3\tmid=160440736725092815\tstid=105487.316514729.2808901204191933009412105634594\tftype=3\temailFrom=realty-news@yandex-team.ru\tlabelSymbols=,,recent_label\tsubject=\\u041d\\u043e\\u0432\\u044b\\u0435 \\u043e\\u0431\\u044a\\u044f\\u0432\\u043b\\u0435\\u043d\\u0438\\u044f: \\u043a\\u0443\\u043f\\u0438\\u0442\\u044c \\u043a\\u0432\\u0430\\u0440\\u0442\\u0438\\u0440\\u0443 \\u0432 \\u0421\\u0430\\u043d\\u043a\\u0442-\\u041f\\u0435\\u0442\\u0435\\u0440\\u0431\\u0443\\u0440\\u0433\\u0435 \\u0438 \\u041b\\u041e, \\u0426\\u0435\\u043d\\u0430 \\u0434\\u043e 5\\u2009000\\u2009000 \\u0440\\u0443\\u0431.; \\u0432\\u0442\\u043e\\u0440\\u0438\\u0447\\u043a\\u0430\tmsgId=<20161117135846.303966.98216.5288.16553@delivery1o.cmail.yandex.net>
tskv\ttskv_format=mail-user-journal-tskv-log\ttableName=users_history\tuid=00000000000153767668\tmodule=fastsrv\tip=2a02:6b8:0:2519::116\tsuid=462338629\tconnectionId=45TlrfZsPd-6sWO98mi\ttarget=message\toperation=receive\tdate=1486588015662\tunixtime=1486588015\thidden=0\tmdb=pg\tstate=X-Mailru-Msgtype="new_question"\taffected=1\tfid=1\tmid=161285161655220009\ttid=161285161655220009\tstid=105346.462338629.280890120430163500412104586018\tftype=1\temailFrom=robot@sprashivalka.com\tlabelSymbols=,,recent_label\tsubject=\u2753 Midset \u0436\u0434\u0451\u0442 \u0432\u0430\u0448\u0435\u0433\u043e \u043e\u0442\u0432\u0435\u0442\u0430\tmsgId=<1ecf423400269508856c3792f303ab79@swift.generated>\t
tskv\ttskv_format=mail-user-journal-tskv-log\ttableName=users_history\tuid=00000000000113430969\tmodule=fastsrv\tip=2a02:6b8:0:f05::94\tsuid=316514729\tconnectionId=GD3k7vvgSI-6sW0W9aL\ttarget=message\toperation=receive\tdate=1486588015251\tunixtime=1486588015\thidden=0\tmdb=pg\taffected=1\tfid=3\tmid=160440736725092815\tstid=105487.316514729.2808901204191933009412105634594\tftype=3\temailFrom=realty-news@yandex-team.ru\tlabelSymbols=,,recent_label\tsubject=\\u041d\\u043e\\u0432\\u044b\\u0435 \\u043e\\u0431\\u044a\\u044f\\u0432\\u043b\\u0435\\u043d\\u0438\\u044f: \\u043a\\u0443\\u043f\\u0438\\u0442\\u044c \\u043a\\u0432\\u0430\\u0440\\u0442\\u0438\\u0440\\u0443 \\u0432 \\u0421\\u0430\\u043d\\u043a\\u0442-\\u041f\\u0435\\u0442\\u0435\\u0440\\u0431\\u0443\\u0440\\u0433\\u0435 \\u0438 \\u041b\\u041e, \\u0426\\u0435\\u043d\\u0430 \\u0434\\u043e 5\\u2009000\\u2009000 \\u0440\\u0443\\u0431.; \\u0432\\u0442\\u043e\\u0440\\u0438\\u0447\\u043a\\u0430\tmsgId=<20161117135846.303966.98216.5288.16553@delivery1o.cmail.yandex.net>
tskv\ttskv_format=mail-user-journal-tskv-log\ttableName=users_history\tuid=00000000000153767668\tmodule=fastsrv\tip=2a02:6b8:0:2519::116\tsuid=462338629\tconnectionId=45TlrfZsPd-6sWO98mi\ttarget=message\toperation=receive\tdate=1486588015662\tunixtime=1486588015\thidden=0\tmdb=pg\taffected=1\tfid=1\tmid=161285161655220009\ttid=161285161655220009\tstid=105346.462338629.280890120430163500412104586018\tftype=1\temailFrom=robot@sprashivalka.com\tlabelSymbols=,,recent_label\tsubject=\u2753 Midset \u0436\u0434\u0451\u0442 \u0432\u0430\u0448\u0435\u0433\u043e \u043e\u0442\u0432\u0435\u0442\u0430\tmsgId=<1ecf423400269508856c3792f303ab79@swift.generated>\temailTo=test3@yandex.ru\temailCC=test4@yandex.ru\temailBCC=test5@yandex.ru\t
tskv\ttskv_format=mail-user-journal-tskv-log\ttableName=users_history\tuid=00001130000022236626\tmodule=fastsrv\tip=127.0.0.1\tsuid=1130000039439900\tconnectionId=OZtdRfqP\ttarget=message\toperation=receive\tdate=1486588013270\tunixtime=1486588013\thidden=1\tmdb=pg\tstate=X-Mailer="Yamail [ http://yandex.ru ] 5.0"\taffected=1\tfid=6\tmid=161285161655205895\ttid=161285161655205895\tstid=105776.1130000039439900.2808901204109379126815876182816\tftype=5\temailFrom=anna@mozgova.ru\tlabelSymbols=draft_label,seen_label\tsubject=вирусы на сайтах\tmsgId=<695031486588012@web12h.yandex.ru>\t
"""
expected_receive = (
    'tskv\tdate=2016-12-05\toperation=receive\tsource=userjournal\town_mail=1\tuid=1130000022236626\tmid=161285161655205895\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\ttid=161285161655205895\tfid=6\temail_from=anna@mozgova.ru\tlocal_from=anna\tdomain_from=mozgova.ru\tsubject=вирусы на сайтах\tsubject_hash=b27fec64b0924b239165f49bec51ca5b\tmessage_id=<695031486588012@web12h.yandex.ru>\tx_mailer=Yamail [ http://yandex.ru ] 5.0',
    'tskv\tdate=2016-12-05\toperation=receive\tsource=userjournal\town_mail=1\tuid=113430969\tmid=160440736725092815\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\tfid=3\temail_from=realty-news@yandex-team.ru\tlocal_from=realty-news\tdomain_from=yandex-team.ru\tsubject=Новые объявления: купить квартиру в Санкт-Петербурге и ЛО, Цена до 5 000 000 руб.; вторичка\tsubject_hash=22d949de991e082aec6484ec7672bf00\tmessage_id=<20161117135846.303966.98216.5288.16553@delivery1o.cmail.yandex.net>\tx_mailer=YandexSender/0.1\tlist_id=<realty.sub.used>',
    'tskv\tdate=2016-12-05\toperation=receive\tsource=userjournal\town_mail=1\tuid=153767668\tmid=161285161655220009\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\ttid=161285161655220009\tfid=1\temail_from=robot@sprashivalka.com\tlocal_from=robot\tdomain_from=sprashivalka.com\tsubject=❓ Midset ждёт вашего ответа\tsubject_hash=a8c38a6319d4a698ca27d387a04c4f1b\tmessage_id=<1ecf423400269508856c3792f303ab79@swift.generated>\tx_mailru_msgtype=new_question',
    'tskv\tdate=2016-12-05\toperation=receive\tsource=userjournal\town_mail=1\tuid=113430969\tmid=160440736725092815\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\tfid=3\temail_from=realty-news@yandex-team.ru\tlocal_from=realty-news\tdomain_from=yandex-team.ru\tsubject=Новые объявления: купить квартиру в Санкт-Петербурге и ЛО, Цена до 5 000 000 руб.; вторичка\tsubject_hash=22d949de991e082aec6484ec7672bf00\tmessage_id=<20161117135846.303966.98216.5288.16553@delivery1o.cmail.yandex.net>',
    'tskv\tdate=2016-12-05\toperation=receive\tsource=userjournal\town_mail=1\tuid=153767668\tmid=161285161655220009\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\ttid=161285161655220009\tfid=1\temail_from=robot@sprashivalka.com\tlocal_from=robot\tdomain_from=sprashivalka.com\tsubject=❓ Midset ждёт вашего ответа\tsubject_hash=a8c38a6319d4a698ca27d387a04c4f1b\tmessage_id=<1ecf423400269508856c3792f303ab79@swift.generated>',
    'tskv\tdate=2016-12-05\toperation=receive\tsource=userjournal\town_mail=1\tuid=1130000022236626\tmid=161285161655205895\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\ttid=161285161655205895\tfid=6\temail_from=anna@mozgova.ru\tlocal_from=anna\tdomain_from=mozgova.ru\tsubject=вирусы на сайтах\tsubject_hash=b27fec64b0924b239165f49bec51ca5b\tmessage_id=<695031486588012@web12h.yandex.ru>\tx_mailer=Yamail [ http://yandex.ru ] 5.0',
)

data_reading = """
tskv\tclientVer=12.6.503\ttestBuckets=35472,0,8;21980,0,4;25468,0,42;34680,0,45;32334,0,33\tuid=207035597\tunixtime=1481057994\ttableName=users_history\tmodule=jsintegration\ttimezone=+0300\tuserIp=37.110.35.205\tuserAgent=Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36\toperation=startReading\tuuid=u2709-1481057304787-66099009\tmid=160722211701799687\tstate=160722211701799687\tyandexuid=9403259441471762018\tsubkey=\tstatus=ok\tenabledTestBuckets=35472,0,8;21980,0,4;25468,0,42;34680,0,45;32334,0,33\ttimestamp=2016-12-06 23:59:54\tsource_uri=prt://userjournal@web16g.yandex.ru/var/log/wmi/jsintegration.log\ttestIds=35472,21980,25468,34680,32334\tisSearch=false\tdate=1481057994124\ttskv_format=mail-user-journal-log\treadingId=9403259441471762018628e495da2d16\trequestId=5bc5768beb890e96364357d0bad3e33b\tiso_eventtime=2016-12-06 23:59:54\ttarget=message\tclient=LIZA\torgId=users_history
tskv\tclientVer=12.6.503\ttestBuckets=34424,0,21;25469,0,28;34679,0,51;32334,0,31\tuid=34642827\tunixtime=1481057994\ttableName=users_history\tmodule=jsintegration\ttimezone=+0300\tuserIp=91.215.121.233\tuserAgent=Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/29.0.1547.76 Safari/537.36 OPR/16.0.1196.80\toperation=startReading\tuuid=u2709-1481057901274-29647794\tmid=160722211701786362\tstate=160722211701786362\tyandexuid=2316562501474032161\tsubkey=\tstatus=ok\tenabledTestBuckets=34424,0,21;25469,0,28;34679,0,51\ttimestamp=2016-12-06 23:59:53\tsource_uri=prt://userjournal@web25m.yandex.ru/var/log/wmi/jsintegration.log\ttestIds=34424,25469,34679\tisSearch=false\tdate=1481057993774\ttskv_format=mail-user-journal-log\treadingId=2316562501474032161f2af7134\trequestId=ee2de77f43e6e3365237ecffad42ae46\tiso_eventtime=2016-12-06 23:59:54\ttarget=message\tclient=LIZA\torgId=users_history
tskv\tclientVer=4.9.6\ttestBuckets=33517,0,77\tuid=58901237\tunixtime=1481057967\ttableName=users_history\tmodule=jsintegration\ttimezone=+0300\tuserIp=195.9.5.4\tuserAgent=Mozilla/5.0 (Linux; Android 6.0.1; SM-G900F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.85 Mobile Safari/537.36\toperation=stopReading\tuuid=iface-1481057805727-68468345\tmid=160722211701790497\tstate=160722211701790497\tyandexuid=1923940891455481310\tsubkey=\tstatus=ok\tenabledTestBuckets=33517,0,77\ttimestamp=2016-12-06 23:59:27\tsource_uri=prt://userjournal@web8j.yandex.ru/var/log/wmi/jsintegration.log\ttestIds=33517\tisSearch=false\tdate=1481057967000\ttskv_format=mail-user-journal-log\treadingId=1923940891455481310f64f7fd565ce3\trequestId=f8eabce9651ffed10b434862c8011b9b\tiso_eventtime=2016-12-06 23:59:27\ttarget=message\tclient=QUINN\torgId=users_history
tskv\tclientVer=4.9.6\ttestBuckets=32957,0,92;25467,0,10;33518,0,38\tuid=9286631\tunixtime=1481057966\ttableName=users_history\tmodule=jsintegration\tuserAgent=Mozilla/5.0 (iPad; CPU OS 8_1_3 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) CriOS/43.0.2357.61 Mobile/12B466 Safari/600.1.4\tuserIp=89.169.135.19\ttimezone=+0300\toperation=stopReading\tuuid=iface-1481057915116-47640779\tmid=160722211701796611\tpercentDisplayed=100\tstate=160722211701796611\tsubkey=\tyandexuid=744996481359234591\trequestId=55f0d4cffac1f415a352fc0f6e1a2c4c\tstatus=ok\tenabledTestBuckets=32957,0,92;25467,0,10;33518,0,38\ttimestamp=2016-12-06 23:59:26\tsource_uri=prt://userjournal@web1g.yandex.ru/var/log/wmi/jsintegration.log\ttestIds=32957,25467,33518\tisSearch=false\tdate=1481057966000\ttskv_format=mail-user-journal-log\treadingId=744996481359234591c5b19f5e\tiso_eventtime=2016-12-06 23:59:26\ttarget=message\tclient=QUINN\torgId=users_history
"""
expected_reading = (
    'tskv\tdate=2016-12-05\toperation=start_reading\tsource=userjournal\town_mail=1\tuid=207035597\tmid=160722211701799687\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=start_reading\tsource=userjournal\town_mail=1\tuid=34642827\tmid=160722211701786362\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=stop_reading\tsource=userjournal\town_mail=1\tuid=58901237\tmid=160722211701790497\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=stop_reading\tsource=userjournal\town_mail=1\tuid=9286631\tmid=160722211701796611\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\treaded_percent=100',
)

data_trash = """
tskv\tyandexuidCookie=1975067751449419355\taffected=1\tuid=00000000000114298100\tsuid=318941499\tmdb=pg\tip=5.166.6.216\tsource_uri=prt://userjournal@web18o.yandex.ru/var/log/mops/user_journal.tskv\ttableName=users_history\tmodule=mailbox_oper\tmids=160722211701786477\tstate=160722211701786477\tsubkey\ttskv_format=mail-user-journal-tskv-log\tunixtime=1481057990\tdate=1481057990688\tuserAgent=Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 YaBrowser/16.10.1.1116 Yowser/2.5 Safari/537.36\toperation=trash\ttarget=message\tiso_eventtime=2016-12-06 23:59:50\trequestId=27b2b93b640709c7954012fd8e672b9d
tskv\tuid=00000000000428978529\tclientType=TOUCH\tmdb=pg\tip=95.153.128.190\ttableName=users_history\tmodule=mailbox_oper\tuserAgent=Mozilla/5.0 (Linux; Android 5.1; Benefit_S502 Build/LMY47I) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/39.0.0.0 Mobile Safari/537.36\toperation=trash\tsuid=957533177\tstate=160722211701784677\tunixtime=1481057990\trequestId=213d9be9a6940afb36b8f030c6e8cc32\taffected=1\tsubkey\tsource_uri=prt://userjournal@web7h.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=iface-1481057871440-18715056\tdate=1481057990051\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:50\ttarget=message\tyandexuidCookie=3628803321476377285\tmids=160722211701784677
"""
expected_trash = (
    'tskv\tdate=2016-12-05\toperation=trash\tsource=userjournal\town_mail=1\tuid=114298100\tmid=160722211701786477\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
    'tskv\tdate=2016-12-05\toperation=trash\tsource=userjournal\town_mail=1\tuid=428978529\tmid=160722211701784677\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44',
)

data_view = """
tskv\torigin=list-widget\tclientVer=12.6.503\ttestBuckets=33824,0,74;33943,0,74;25469,0,42;34680,0,50;32334,0,64\tuid=339634167\tunixtime=1481057968\ttableName=users_history\tmodule=jsintegration\tuserAgent=Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 YaBrowser/16.10.1.1114 Yowser/2.5 Safari/537.36\tuserIp=94.25.186.86\ttimezone=+0300\toperation=view\tuuid=u2709-1481055525787-46650194\tmid=160440736725074783\tstate=160440736725074783\trequestId=034ae3c10da1e7f1acda7543005936c8\tsubkey=\tstatus=ok\tenabledTestBuckets=33824,0,74;33943,0,74;25469,0,42;34680,0,50\twidgetType=avia\ttimestamp=2016-12-06 23:59:28\tsource_uri=prt://userjournal@web27m.yandex.ru/var/log/wmi/jsintegration.log\ttestIds=33824,33943,25469,34680\tyandexuid=4259718031448404116\twidgetSubType=ticket\tdate=1481057968138\ttskv_format=mail-user-journal-log\tiso_eventtime=2016-12-06 23:59:28\ttarget=message\tclient=LIZA\torgId=users_history
tskv\torigin=list-widget\tclientVer=12.6.503\ttestBuckets=33818,0,69;34378,0,79;34680,0,55;32334,0,50\tuid=92513401\tunixtime=1481057968\ttableName=users_history\tmodule=jsintegration\tuserAgent=Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36\tuserIp=176.96.5.225\ttimezone=+0300\toperation=view\tuuid=u2709-1481057961669-18902470\tmid=159033361841521733\tstate=159033361841521733\trequestId=e3fc062eb8cf76e1f1559e90db6d638e\tsubkey=\tstatus=ok\tenabledTestBuckets=33818,0,69;34378,0,79;34680,0,55\twidgetType=hotels\ttimestamp=2016-12-06 23:59:28\tsource_uri=prt://userjournal@web36m.yandex.ru/var/log/wmi/jsintegration.log\ttestIds=33818,34378,34680\tyandexuid=9813764901480230718\twidgetSubType=booking\tdate=1481057968402\ttskv_format=mail-user-journal-log\tiso_eventtime=2016-12-06 23:59:28\ttarget=message\tclient=LIZA\torgId=users_history
"""
expected_view = (
    'tskv\tdate=2016-12-05\toperation=view\tsource=userjournal\town_mail=1\tuid=339634167\tmid=160440736725074783\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\twidget=avia:ticket',
    'tskv\tdate=2016-12-05\toperation=view\tsource=userjournal\town_mail=1\tuid=92513401\tmid=159033361841521733\taction_date=2016-12-05 23:59:44\tevent_date=2016-12-06 23:59:44\twidget=hotels:booking',
)

data_errors = """
tskv
tskv\tuid=00000000000277570702\tclientType=mob-app-unknown\tmdb=pg\tip=94.242.161.227\ttableName=users_history\tmodule=spam_report\tuserAgent=ru.yandex.mail/3.12.29527 (HUAWEI HUAWEI TAG-L21; Android 5.1)\toperation=abuse\tsuid=823531216\tstate=unread_trash;160722211701789292\tunixtime=1481057984\trequestId=9d6c7d279a176635a6debb8677a2a474\taffected=1\tsubkey= source_uri=prt://userjournal@web28h.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=1ed630fda8fe83fc2f674ac4617e4f06\tdate=1481057984029\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:44\ttarget=message\tabuseType=unread_trash\tmids=BadValues,
tskv\tuid=BadValue\tclientType=mob-app-unknown\tmdb=pg\tip=94.242.161.227\ttableName=users_history\tmodule=spam_report\tuserAgent=ru.yandex.mail/3.12.29527 (HUAWEI HUAWEI TAG-L21; Android 5.1)\toperation=abuse\tsuid=823531216\tstate=unread_trash;160722211701789292\tunixtime=1481057984\trequestId=9d6c7d279a176635a6debb8677a2a474\taffected=1\tsubkey= source_uri=prt://userjournal@web28h.yandex.ru/var/log/mops/user_journal.tskv\tconnectionId=1ed630fda8fe83fc2f674ac4617e4f06\tdate=1481057984029\ttskv_format=mail-user-journal-tskv-log\tiso_eventtime=2016-12-06 23:59:44\ttarget=message\tabuseType=unread_trash\tmids=160722211701789292
"""

data = ''.join((
    data_abuse,
    data_click,
    data_delete,
    data_mark,
    data_move,
    data_receive,
    data_reading,
    data_trash,
    data_view,
    data_errors,
))

expected = (
    expected_abuse +
    expected_click +
    expected_delete +
    expected_mark +
    expected_move +
    expected_receive +
    expected_reading +
    expected_trash +
    expected_view +
    ()
)
