#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import absolute_import
from optparse import OptionParser

import yenv
from logbroker_client.logbroker_app import create_app


DEFAULT_CONFIG_PATH = '/etc/yandex/logbroker-client/'


def main():
    optparser = OptionParser()

    optparser.add_option("-s", "--service", dest="service", help="name of service")
    optparser.add_option("-p", "--path", dest="path", help="path to configs")
    optparser.add_option("-c", "--config", dest="config", help="path to config")  # for debug usage

    options, args = optparser.parse_args()

    config_file = None

    if not options.service and not options.config:
        optparser.error("--service or --config option is required")
    elif options.config:
        config_file = options.config
    elif options.service:
        config_path = DEFAULT_CONFIG_PATH
        if options.path:
            config_path = options.path
        config_file = config_path + options.service + '/' + yenv.type + ".json"

    create_app(config_file)


if __name__ == '__main__':
    main()
