# -*- coding: utf-8 -*-
from fabric.api import (
    env,
    local,
    task,
)
from passport_ci.buildfarm import *
from passport_ci.development import *
from robe import (
    debian,
    venv,
)

env.robe.projects = {
    'logbroker-client': {
        'path': '.',
        'use_global_site_packages': True,
    },
}

env.robe.dev_dir = 'venv'
env.robe.venv.dev_requirements_file = 'requirements-dev.txt'
env.robe.debian.repository = 'passport-precise'
env.robe.venv.accelerator = 'wheel'
env.robe.venv.quiet_install = False

env.passport.pypi_release_dirs = ['.']
env.passport.coverage_tests = 'PYTHONPATH=.:$PYTHONPATH py.test --cov logbroker_client tests'
env.passport.git = [
    {
        'dir': '.',
        'owner': 'passport',
        'repository': 'logbroker-client',
    },
]


PYTHONPATH = '.:$PYTHONPATH'


@task()
def test(mode=None, test=''):
    clean()

    with venv.activate():
        if mode == 'dev':
            local('PYTHONPATH=%s py.test %s' % (PYTHONPATH, test if test else 'tests'))
        else:
            local('PYTHONPATH=.:$PYTHONPATH py.test %s' % (test if test else 'tests'))


@task()
def run(service, config):
    with venv.activate():
        local('PYTHONPATH=%s python -B ../logbroker-client/bin/logbroker-client --service=%s --config=%s' %
              (PYTHONPATH, service, config))


@task()
def changelog():
    is_upstream()
    local('dch -iU -D unstable --force-distribution')
    local('passport-clean-changelog')

    for pypi_dir in env.passport.pypi_release_dirs:
        local("dpkg-parsechangelog | sed -n 's/^Version: //p' > %s" % os.path.join(pypi_dir, env.passport.pypi_version_file))

    local('git add -p && debcommit -rR')
