# -*- coding: utf-8 -*-
import logging

import requests

from logbroker_client.utils import retriable_n
from logbroker_client.handlers.exceptions import ResponseClientError, RequestClientError


log = logging.getLogger(__name__)


class NotifyClient(object):
    def __init__(self, service_name, url, timeout=5.0):
        self._url = url
        self._timeout = timeout
        self.service_name = service_name

    @retriable_n(retry_count=5, time_sleep=0.5)
    def _request(self, url, data):
        try:
            response = requests.request('POST', url, data=data, timeout=self._timeout)
            if response.status_code != 200:
                raise ResponseClientError(response.status_code, response.text, response.request)
            return response
        except requests.exceptions.RequestException, e:
            log.warn('Error %s during request to %s' % (e, url))
            raise RequestClientError(e, url, data)

    def notify(self, uid, event_name, event_timestamp):
        data = {
            'v': 1,
            'uid': uid,
            'event': event_name,
            'timestamp': event_timestamp,
        }
        self._request(self._url, data)
