# -*- coding: utf-8 -*-
import os
import json
from logging.config import dictConfig

from .utils import importobj
from .settings.consumer.logs import build_logging
from .runner.arbiter import Arbiter


def create_logdir(logpath):
    try:
        os.makedirs(logpath, 0755)
    except OSError:
        pass


def configure(config_file):
    config = json.load(open(config_file))

    logpath = config.get('logpath')
    create_logdir(logpath)

    logger_builder = config.get('logger_builder')
    if logger_builder:
        log_config_builder = importobj(logger_builder)
    else:
        log_config_builder = build_logging

    dictConfig(log_config_builder(logpath))
    return config


def create_app(config_file):
    config = configure(config_file)

    a = Arbiter()
    a.run(config)
